/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanTest
extends AbstractXPathTest {
    @Test
    public void nonEmptyNodeSetsAreTrue() throws Exception {
        List hits = this.getByXpath("<root><y/></root>", "boolean(//y)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void emptyNodeSetsAreFalse() throws Exception {
        List hits = this.getByXpath("<root><z/></root>", "boolean(//y)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void zeroIsFalse() throws Exception {
        List hits = this.getByXpath("boolean(0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void emptyStringIsFalse() throws Exception {
        List hits = this.getByXpath("boolean('')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void naNIsFalse() throws Exception {
        List hits = this.getByXpath("boolean(0 div 0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void nonEmptyStringIsTrue() throws Exception {
        List hits = this.getByXpath("boolean('false')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void booleanFunctionRequiresAtLeastOneArgument() throws Exception {
        this.assertGetByXpathException("boolean()", "Could not retrieve XPath >boolean()< on [#document: null]", "FuncBoolean only allows 1 arguments");
    }

    @Test
    public void booleanFunctionRequiresExactlyOneArgument() throws Exception {
        this.assertGetByXpathException("boolean('', '')", "Could not retrieve XPath >boolean('', '')< on [#document: null]", "FuncBoolean only allows 1 arguments");
    }
}

