/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CeilingTest
extends AbstractXPathTest {
    @Test
    public void ceiling() throws Exception {
        List hits = this.getByXpath("ceiling(1.5)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)2.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void negativeCeiling() throws Exception {
        List hits = this.getByXpath("ceiling(-1.5)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)-1.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void naNCeilingIsNaN() throws Exception {
        List hits = this.getByXpath("ceiling(1.0 div 0.0 - 2.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isNaN(result));
    }

    @Test
    public void infCeilingIsInf() throws Exception {
        List hits = this.getByXpath("ceiling(1.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isInfinite(result));
        Assertions.assertTrue((result > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void negativeInfCeilingIsNegativeInf() throws Exception {
        List hits = this.getByXpath("ceiling(-11.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isInfinite(result));
        Assertions.assertTrue((result < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void ceilingFunctionRequiresAtLeastOneArgument() throws Exception {
        this.assertGetByXpathException("ceiling()", "Could not retrieve XPath >ceiling()< on [#document: null]", "FuncCeiling only allows 1 arguments");
    }

    @Test
    public void ceilingFunctionRequiresExactlyOneArgument() throws Exception {
        this.assertGetByXpathException("ceiling(2.2, 1.2)", "Could not retrieve XPath >ceiling(2.2, 1.2)< on [#document: null]", "FuncCeiling only allows 1 arguments");
    }
}

