/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConcatTest
extends AbstractXPathTest {
    @Test
    public void concat() throws Exception {
        List hits = this.getByXpath("concat('a', 'b')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"ab", hits.get(0));
    }

    @Test
    public void concatMany() throws Exception {
        List hits = this.getByXpath("concat('a', 'b', 'c', 'd')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"abcd", hits.get(0));
    }

    @Test
    public void concatFunctionRequiresAtLeastOneArgument() throws Exception {
        this.assertGetByXpathException("concat()", "Could not retrieve XPath >concat()< on [#document: null]", "FuncConcat only allows >1 arguments");
    }

    @Test
    public void concatFunctionRequiresAtLeastTwoArguments() throws Exception {
        this.assertGetByXpathException("concat('a')", "Could not retrieve XPath >concat('a')< on [#document: null]", "FuncConcat only allows >1 arguments");
    }
}

