/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContainsTest
extends AbstractXPathTest {
    @Test
    public void containsNumber() throws Exception {
        List hits = this.getByXpath("contains(33, '3')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void containsNumberAll() throws Exception {
        List hits = this.getByXpath("contains(12.34, '12.34')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void containsNumberNot() throws Exception {
        List hits = this.getByXpath("contains(33, '4')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void containsString() throws Exception {
        List hits = this.getByXpath("contains('test', 'es')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void containsStringAll() throws Exception {
        List hits = this.getByXpath("contains('xpath', 'xpath')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void containsStringNot() throws Exception {
        List hits = this.getByXpath("contains('xpath', 'y')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void emptyStringContainsNonEmptyString() throws Exception {
        List hits = this.getByXpath("contains('', 'y')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void emptyStringContainsEmptyString() throws Exception {
        List hits = this.getByXpath("contains('', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void containsEmptyString() throws Exception {
        List hits = this.getByXpath("contains('xpath', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void containsFunctionRequiresAtLeastTwoArguments() throws Exception {
        this.assertGetByXpathException("contains('a')", "Could not retrieve XPath >contains('a')< on [#document: null]", "FuncContains only allows 2 arguments");
    }

    @Test
    public void containsFunctionRequiresAtMostTwoArguments() throws Exception {
        this.assertGetByXpathException("contains('a', 'b', '')", "Could not retrieve XPath >contains('a', 'b', '')< on [#document: null]", "FuncContains only allows 2 arguments");
    }
}

