/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CountTest
extends AbstractXPathTest {
    @Test
    public void count() throws Exception {
        List hits = this.getByXpath("count(/*)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)1.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void countFunctionRequiresNodeSet() throws Exception {
        this.assertGetByXpathException("count(7)", "Could not retrieve XPath >count(7)< on [#document: null]", "Can not convert #NUMBER to a NodeList!");
    }

    @Test
    public void containsFunctionRequiresAtLeastOneArguments() throws Exception {
        this.assertGetByXpathException("count()", "Could not retrieve XPath >count()< on [#document: null]", "FuncCount only allows 1 arguments");
    }

    @Test
    public void containsFunctionRequiresAtMostOneArguments() throws Exception {
        this.assertGetByXpathException("count('a', 7)", "Could not retrieve XPath >count('a', 7)< on [#document: null]", "FuncCount only allows 1 arguments");
    }
}

