/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FalseTest
extends AbstractXPathTest {
    @Test
    public void falseLessThanOrEqualToFalse() throws Exception {
        List hits = this.getByXpath("false() <= false()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void emptyNodeSetLessThanOrEqualToFalse() throws Exception {
        List hits = this.getByXpath("/nonexistent<=false()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void emptyNodeSetLessThanFalse() throws Exception {
        List hits = this.getByXpath("/nonexistent<false()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void falseLessThanOrEqualToEmptyNodeSet() throws Exception {
        List hits = this.getByXpath("false()<=/nonexistent");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void falseGreaterThanOrEqualToEmptyNodeSet() throws Exception {
        List hits = this.getByXpath("false()>=/nonexistent");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void falseGreaterThaEmptyNodeSet() throws Exception {
        List hits = this.getByXpath("false()>/nonexistent");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void falseFunctionRequiresNoArgument() throws Exception {
        this.assertGetByXpathException("false(1)", "Could not retrieve XPath >false(1)< on [#document: null]", "FuncFalse only allows 0 arguments");
    }
}

