/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FloorTest
extends AbstractXPathTest {
    @Test
    public void floor() throws Exception {
        List hits = this.getByXpath("floor(1.5)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)1.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void negativeFloor() throws Exception {
        List hits = this.getByXpath("floor(-1.5)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)-2.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void naNFloorIsNaN() throws Exception {
        List hits = this.getByXpath("floor(1.0 div 0.0 - 2.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isNaN(result));
    }

    @Test
    public void infFloorIsInf() throws Exception {
        List hits = this.getByXpath("floor(1.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isInfinite(result));
        Assertions.assertTrue((result > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void negativeInfFloorIsNegativeInf() throws Exception {
        List hits = this.getByXpath("floor(-11.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isInfinite(result));
        Assertions.assertTrue((result < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void floorFunctionRequiresAtLeastOneArgument() throws Exception {
        this.assertGetByXpathException("floor()", "Could not retrieve XPath >floor()< on [#document: null]", "FuncFloor only allows 1 arguments");
    }

    @Test
    public void floorFunctionRequiresExactlyOneArgument() throws Exception {
        this.assertGetByXpathException("floor(2.2, 1.2)", "Could not retrieve XPath >floor(2.2, 1.2)< on [#document: null]", "FuncFloor only allows 1 arguments");
    }
}

