/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdTest
extends AbstractXPathTest {
    @Test
    public void idFunctionSelectsNothingInDocumentWithNoIds() throws Exception {
        List hits = this.getByXpath("id('rootId')");
        Assertions.assertEquals((int)0, (int)hits.size());
    }

    @Test
    public void id() throws Exception {
        List hits = this.getByXpath("<!DOCTYPE root [<!ATTLIST a id ID #REQUIRED>]><root><a id='myId'/></root>", "id('myId')");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void findMultipleElementsByMultipleIDs() throws Exception {
        List hits = this.getByXpath("<!DOCTYPE root [<!ATTLIST a id ID #REQUIRED>]><root><id>p1</id><id>p2</id><id>p3</id><a id='p1'/><a id='p2'/></root>", "id(//id)");
        Assertions.assertEquals((int)2, (int)hits.size());
    }

    @Test
    public void returnsFirstElementWithMatchingId() throws Exception {
        List hits = this.getByXpath("<!DOCTYPE root [<!ATTLIST a id ID #REQUIRED><!ATTLIST b id ID #REQUIRED>]><root><a id='p1'/><b id='p1'/></root>", "id('p1')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"[a: null]", (Object)hits.get(0).toString());
    }

    @Test
    public void idFunctionRequiresAtLeastOneArgument() throws Exception {
        this.assertGetByXpathException("id()", "Could not retrieve XPath >id()< on [#document: null]", "FuncId only allows 1 arguments");
    }

    @Test
    public void floorFunctionRequiresExactlyOneArgument() throws Exception {
        this.assertGetByXpathException("id('a', 'b')", "Could not retrieve XPath >id('a', 'b')< on [#document: null]", "FuncId only allows 1 arguments");
    }
}

