/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Node;

public class LastTest
extends AbstractXPathTest {
    @Test
    public void last() throws Exception {
        String xml = "<root><a><x>2</x></a><b><x>3</x><x>4</x></b></root>";
        List hits = this.getByXpath("<root><a><x>2</x></a><b><x>3</x><x>4</x></b></root>", "//x[position()=last()]");
        Assertions.assertEquals((int)2, (int)hits.size());
        Assertions.assertEquals((Object)"2", (Object)((Node)hits.get(0)).getTextContent());
        Assertions.assertEquals((Object)"4", (Object)((Node)hits.get(1)).getTextContent());
    }

    @Test
    public void lastEmptyList() throws Exception {
        List hits = this.getByXpath("//x[position()=last()]");
        Assertions.assertEquals((int)0, (int)hits.size());
    }

    @Test
    public void falseFunctionRequiresNoArgument() throws Exception {
        this.assertGetByXpathException("//x[position()=last(.)]", "Could not retrieve XPath >//x[position()=last(.)]< on [#document: null]", "FuncLast only allows 0 arguments");
    }
}

