/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NotTest
extends AbstractXPathTest {
    @Test
    public void notZero() throws Exception {
        List hits = this.getByXpath("not(0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void notOne() throws Exception {
        List hits = this.getByXpath("not(1)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void notEmptyString() throws Exception {
        List hits = this.getByXpath("not('')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void notString() throws Exception {
        List hits = this.getByXpath("not('false')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void notFunctionRequiresAtLeastOneArgument() throws Exception {
        this.assertGetByXpathException("not()", "Could not retrieve XPath >not()< on [#document: null]", "FuncNot only allows 1 arguments");
    }

    @Test
    public void notFunctionRequiresExactlyOneArgument() throws Exception {
        this.assertGetByXpathException("not('', '')", "Could not retrieve XPath >not('', '')< on [#document: null]", "FuncNot only allows 1 arguments");
    }
}

