/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QnameTest
extends AbstractXPathTest {
    @Test
    public void name() throws Exception {
        List hits = this.getByXpath("<root>4</root>", "name(/root)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"root", hits.get(0));
    }

    @Test
    public void nameMany() throws Exception {
        List hits = this.getByXpath("<root><a>4</a><a>3</a></root>", "name(/*/a)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"a", hits.get(0));
    }

    @Test
    public void nameEmpty() throws Exception {
        List hits = this.getByXpath("name(/o)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void nameOfNumber() throws Exception {
        this.assertGetByXpathException("name(7)", "Could not retrieve XPath >name(7)< on [#document: null]", "Can not convert #NUMBER to a NodeList!");
    }

    @Test
    public void nameNoArguments() throws Exception {
        List hits = this.getByXpath("name()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void nameOfComment() throws Exception {
        List hits = this.getByXpath("<root><!-- comment --></root>", "name(/root/comment())");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void nameOfAttribute() throws Exception {
        List hits = this.getByXpath("<root attr='abc'></root>", "name(/*/@*)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"attr", hits.get(0));
    }

    @Test
    public void nameOfText() throws Exception {
        List hits = this.getByXpath("<root>abc</root>", "name(/*/text())");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }
}

