/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoundTest
extends AbstractXPathTest {
    @Test
    public void round() throws Exception {
        List hits = this.getByXpath("round(1.5)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)2.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void negativeRound() throws Exception {
        List hits = this.getByXpath("round(-1.5)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)-1.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void negativeRound2() throws Exception {
        List hits = this.getByXpath("round(-0.49)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)0.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void roundZero() throws Exception {
        List hits = this.getByXpath("round(0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((double)0.0, (double)((Double)hits.get(0)), (double)1.0E-4);
    }

    @Test
    public void naNRoundIsNaN() throws Exception {
        List hits = this.getByXpath("round(1.0 div 0.0 - 2.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isNaN(result));
    }

    @Test
    public void infRoundIsInf() throws Exception {
        List hits = this.getByXpath("round(1.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isInfinite(result));
        Assertions.assertTrue((result > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void negativeInfRoundIsNegativeInf() throws Exception {
        List hits = this.getByXpath("round(-11.0 div 0.0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        double result = (Double)hits.get(0);
        Assertions.assertTrue((boolean)Double.isInfinite(result));
        Assertions.assertTrue((result < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void roundFunctionRequiresAtLeastOneArgument() throws Exception {
        this.assertGetByXpathException("round()", "Could not retrieve XPath >round()< on [#document: null]", "FuncRound only allows 1 arguments");
    }

    @Test
    public void roundFunctionRequiresExactlyOneArgument() throws Exception {
        this.assertGetByXpathException("round(2.2, 1.2)", "Could not retrieve XPath >round(2.2, 1.2)< on [#document: null]", "FuncRound only allows 1 arguments");
    }
}

