/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartsWithTest
extends AbstractXPathTest {
    @Test
    public void startsWithNumber() throws Exception {
        List hits = this.getByXpath("starts-with(33, '3')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void startsWithNumberAll() throws Exception {
        List hits = this.getByXpath("starts-with(12.34, '12.34')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void startsWithNumberNot() throws Exception {
        List hits = this.getByXpath("starts-with(34, '4')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void startsWithString() throws Exception {
        List hits = this.getByXpath("starts-with('test', 'te')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void startsWithStringAll() throws Exception {
        List hits = this.getByXpath("starts-with('xpath', 'xpath')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void startsWithStringNot() throws Exception {
        List hits = this.getByXpath("starts-with('xpath', 'y')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void emptyStringStartsWithNonEmptyString() throws Exception {
        List hits = this.getByXpath("starts-with('', 'y')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void emptyStringStartsWithEmptyString() throws Exception {
        List hits = this.getByXpath("starts-with('', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void startsWithEmptyString() throws Exception {
        List hits = this.getByXpath("starts-with('xpath', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void startsWithFunctionRequiresAtLeastTwoArguments() throws Exception {
        this.assertGetByXpathException("starts-with('a')", "Could not retrieve XPath >starts-with('a')< on [#document: null]", "FuncStartsWith only allows 2 arguments");
    }

    @Test
    public void startsWithFunctionRequiresAtMostTwoArguments() throws Exception {
        this.assertGetByXpathException("starts-with('a', 'b', '')", "Could not retrieve XPath >starts-with('a', 'b', '')< on [#document: null]", "FuncStartsWith only allows 2 arguments");
    }
}

