/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringLengthTest
extends AbstractXPathTest {
    @Test
    public void stringLengthOfNumber() throws Exception {
        List hits = this.getByXpath("string-length(3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((int)1, (int)((Double)hits.get(0)).intValue());
    }

    @Test
    public void stringLengthOfEmptyString() throws Exception {
        List hits = this.getByXpath("string-length('')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((int)0, (int)((Double)hits.get(0)).intValue());
    }

    @Test
    public void stringLengthOfString() throws Exception {
        List hits = this.getByXpath("string-length('0123456789')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((int)10, (int)((Double)hits.get(0)).intValue());
    }

    @Test
    public void stringLengthFunctionOperatesOnContextNode() throws Exception {
        List hits = this.getByXpath("string-length()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((int)0, (int)((Double)hits.get(0)).intValue());
    }

    @Test
    public void containsFunctionRequiresAtMostOneArguments() throws Exception {
        this.assertGetByXpathException("string-length('a', 7)", "Could not retrieve XPath >string-length('a', 7)< on [#document: null]", "FuncStringLength only allows 0 or 1 arguments");
    }
}

