/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringTest
extends AbstractXPathTest {
    @Test
    public void stringFunctionOperatesOnFirstNodeInDocumentOrder() throws Exception {
        List hits = this.getByXpath("<root><a><b><x>2</x><x>3</x></b><x>4</x></a></root>", "string(//x)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"2", hits.get(0));
    }

    @Test
    public void stringOfInfinity() throws Exception {
        List hits = this.getByXpath("string(1 div 0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"Infinity", hits.get(0));
    }

    @Test
    public void stringOfNegativeInfinity() throws Exception {
        List hits = this.getByXpath("string(-1 div 0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"-Infinity", hits.get(0));
    }

    @Test
    public void stringOfNegativeZero() throws Exception {
        List hits = this.getByXpath("string(-0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"0", hits.get(0));
    }

    @Test
    public void integersAreFormattedAsInts() throws Exception {
        List hits = this.getByXpath("string(12)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"12", hits.get(0));
    }

    @Test
    public void stringWithoutParam() throws Exception {
        List hits = this.getByXpath("string()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void stringFunctionRequiresExactlyOneArgument() throws Exception {
        this.assertGetByXpathException("string('', '')", "Could not retrieve XPath >string('', '')< on [#document: null]", "FuncString only allows 0 or 1 arguments");
    }
}

