/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubstringAfterTest
extends AbstractXPathTest {
    @Test
    public void substringAfterNumber() throws Exception {
        List hits = this.getByXpath("substring-after(1234, 3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"4", hits.get(0));
    }

    @Test
    public void substringAfterNumberFirst() throws Exception {
        List hits = this.getByXpath("substring-after(12444, 4)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"44", hits.get(0));
    }

    @Test
    public void substringAfterNumberUnknown() throws Exception {
        List hits = this.getByXpath("substring-after(1234, 7)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringAfterString() throws Exception {
        List hits = this.getByXpath("substring-after('test', 'es')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"t", hits.get(0));
    }

    @Test
    public void substringAfterStringWhole() throws Exception {
        List hits = this.getByXpath("substring-after('test', 'test')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringAfterStringNotFound() throws Exception {
        List hits = this.getByXpath("substring-after('test', 'tex')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringAfterStringEmpty() throws Exception {
        List hits = this.getByXpath("substring-after('', 'o')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringAfterStringEmptyEmpty() throws Exception {
        List hits = this.getByXpath("substring-after('', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringAfterStringEmptySearch() throws Exception {
        List hits = this.getByXpath("substring-after('text', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"text", hits.get(0));
    }

    @Test
    public void substringAfterFunctionRequiresAtLeastTwoArguments() throws Exception {
        this.assertGetByXpathException("substring-after('a')", "Could not retrieve XPath >substring-after('a')< on [#document: null]", "FuncSubstringAfter only allows 2 arguments");
    }

    @Test
    public void substringAfterFunctionRequiresAtMostThreeArguments() throws Exception {
        this.assertGetByXpathException("substring-after('a', 1, 1, 4)", "Could not retrieve XPath >substring-after('a', 1, 1, 4)< on [#document: null]", "FuncSubstringAfter only allows 2 arguments");
    }
}

