/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubstringBeforeTest
extends AbstractXPathTest {
    @Test
    public void substringBeforeNumber() throws Exception {
        List hits = this.getByXpath("substring-before(1234, 3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"12", hits.get(0));
    }

    @Test
    public void substringBeforeNumberFirst() throws Exception {
        List hits = this.getByXpath("substring-before(12444, 4)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"12", hits.get(0));
    }

    @Test
    public void substringBeforeNumberUnknown() throws Exception {
        List hits = this.getByXpath("substring-before(1234, 7)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringBeforeString() throws Exception {
        List hits = this.getByXpath("substring-before('test', 'es')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"t", hits.get(0));
    }

    @Test
    public void substringBeforeStringWhole() throws Exception {
        List hits = this.getByXpath("substring-before('test', 'test')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringBeforeStringNotFound() throws Exception {
        List hits = this.getByXpath("substring-before('test', 'tex')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringBeforeStringEmpty() throws Exception {
        List hits = this.getByXpath("substring-before('', 'o')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringBeforeStringEmptyEmpty() throws Exception {
        List hits = this.getByXpath("substring-before('', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringBeforeStringEmptySearch() throws Exception {
        List hits = this.getByXpath("substring-before('text', '')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringBeforeFunctionRequiresAtLeastTwoArguments() throws Exception {
        this.assertGetByXpathException("substring-before('a')", "Could not retrieve XPath >substring-before('a')< on [#document: null]", "FuncSubstringBefore only allows 2 arguments");
    }

    @Test
    public void substringBeforeFunctionRequiresAtMostThreeArguments() throws Exception {
        this.assertGetByXpathException("substring-before('a', 1, 1, 4)", "Could not retrieve XPath >substring-before('a', 1, 1, 4)< on [#document: null]", "FuncSubstringBefore only allows 2 arguments");
    }
}

