/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubstringTest
extends AbstractXPathTest {
    @Test
    public void substringOfNumber() throws Exception {
        List hits = this.getByXpath("substring(1234, 3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"34", hits.get(0));
    }

    @Test
    public void substringOfNumber2() throws Exception {
        List hits = this.getByXpath("substring(1234, 2, 3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"234", hits.get(0));
    }

    @Test
    public void unusualSubstring1() throws Exception {
        List hits = this.getByXpath("substring('12345', 1.5, 2.6)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"234", hits.get(0));
    }

    @Test
    public void unusualSubstring2() throws Exception {
        List hits = this.getByXpath("substring('12345', 0, 3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"12", hits.get(0));
    }

    @Test
    public void unusualSubstring3() throws Exception {
        List hits = this.getByXpath("substring('12345', 0 div 0, 3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void unusualSubstring4() throws Exception {
        List hits = this.getByXpath("substring('12345', 1, 0 div 0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void unusualSubstring5() throws Exception {
        List hits = this.getByXpath("substring('12345', -42, 1 div 0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"12345", hits.get(0));
    }

    @Test
    public void unusualSubstring6() throws Exception {
        List hits = this.getByXpath("substring('12345', -1 div 0, 1 div 0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringOfNaN() throws Exception {
        List hits = this.getByXpath("substring(0 div 0, 2)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"aN", hits.get(0));
    }

    @Test
    public void substringOfEmptyString() throws Exception {
        List hits = this.getByXpath("substring('', 2)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringLengthZero() throws Exception {
        List hits = this.getByXpath("substring('12345', 2, 0)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringWithNegativeLength() throws Exception {
        List hits = this.getByXpath("substring('12345', 2, -3)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringWithNegativeLength2() throws Exception {
        List hits = this.getByXpath("substring('12345', 2, -1)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringWithExcessiveLength() throws Exception {
        List hits = this.getByXpath("substring('12345', 2, 32)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"2345", hits.get(0));
    }

    @Test
    public void substringNegativeStartNoLength() throws Exception {
        List hits = this.getByXpath("substring('Hello', -50)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"Hello", hits.get(0));
    }

    @Test
    public void substringNegativeStartWithLength() throws Exception {
        List hits = this.getByXpath("substring('Hello', -50, 20)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void substringFunctionRequiresAtLeastTwoArguments() throws Exception {
        this.assertGetByXpathException("substring('a')", "Could not retrieve XPath >substring('a')< on [#document: null]", "FuncSubstring only allows 2 or 3 arguments");
    }

    @Test
    public void substringFunctionRequiresAtMostThreeArguments() throws Exception {
        this.assertGetByXpathException("substring('a', 1, 1, 4)", "Could not retrieve XPath >substring('a', 1, 1, 4)< on [#document: null]", "FuncSubstring only allows 2 or 3 arguments");
    }
}

