/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SumTest
extends AbstractXPathTest {
    @Test
    public void sum() throws Exception {
        List hits = this.getByXpath("<root>4</root>", "sum(/*)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)4.0, hits.get(0));
    }

    @Test
    public void sumMany() throws Exception {
        List hits = this.getByXpath("<root><a>4</a><a>3</a></root>", "sum(/*/a)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)7.0, hits.get(0));
    }

    @Test
    public void sumEmpty() throws Exception {
        List hits = this.getByXpath("sum(/*)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Double.NaN, hits.get(0));
    }

    @Test
    public void sumOfNumber() throws Exception {
        this.assertGetByXpathException("sum(7)", "Could not retrieve XPath >sum(7)< on [#document: null]", "Can not convert #NUMBER to a NodeList!");
    }

    @Test
    public void sumNoArguments() throws Exception {
        this.assertGetByXpathException("sum()", "Could not retrieve XPath >sum()< on [#document: null]", "FuncSum only allows 1 arguments");
    }
}

