/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TranslateTest
extends AbstractXPathTest {
    @Test
    public void translate() throws Exception {
        List hits = this.getByXpath("translate('abc', 'b', 'd')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"adc", hits.get(0));
    }

    @Test
    public void translateIgnoresExtraArguments() throws Exception {
        List hits = this.getByXpath("translate('abc', 'b', 'dghf')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"adc", hits.get(0));
    }

    @Test
    public void translateStringThatContainsNonBMPChars() throws Exception {
        List hits = this.getByXpath("translate('ab\ud834\udd00b', 'b', 'd')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"ad\ud834\udd00d", hits.get(0));
    }

    @Test
    public void translateWithExtraCharsInReplacementString() throws Exception {
        List hits = this.getByXpath("translate('abc', 'c', 'def')");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"abd", hits.get(0));
    }

    @Test
    public void translateFunctionRequiresAtLeastThreeArguments() throws Exception {
        this.assertGetByXpathException("translate('a', 'b')", "Could not retrieve XPath >translate('a', 'b')< on [#document: null]", "FuncTranslate only allows 3 arguments");
    }

    @Test
    public void translateRequiresAtMostThreeArguments() throws Exception {
        this.assertGetByXpathException("translate('a', 'a', 'a', 'a')", "Could not retrieve XPath >translate('a', 'a', 'a', 'a')< on [#document: null]", "FuncTranslate only allows 3 arguments");
    }
}

