/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TrueTest
extends AbstractXPathTest {
    @Test
    public void trueLessThanOrEqualToTrue() throws Exception {
        List hits = this.getByXpath("true() <= true()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void emptyNodeSetLessThanOrEqualToTrue() throws Exception {
        List hits = this.getByXpath("/nonexistent<=true()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void emptyNodeSetLessThanTrue() throws Exception {
        List hits = this.getByXpath("/nonexistent<true()");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void trueLessThanOrEqualToEmptyNodeSet() throws Exception {
        List hits = this.getByXpath("true()<=/nonexistent");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void trueGreaterThanOrEqualToEmptyNodeSet() throws Exception {
        List hits = this.getByXpath("true()>=/nonexistent");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void trueGreaterThaEmptyNodeSet() throws Exception {
        List hits = this.getByXpath("true()>/nonexistent");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void trueFunctionRequiresNoArgument() throws Exception {
        this.assertGetByXpathException("true(1)", "Could not retrieve XPath >true(1)< on [#document: null]", "FuncTrue only allows 0 arguments");
    }
}

