/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.operations;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArithmeticsTest
extends AbstractXPathTest {
    @Test
    public void numbersThatBeginWithADecimalPoint2() throws Exception {
        List hits = this.getByXpath(".5 > .4");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void numbersThatBeginWithADecimalPoint() throws Exception {
        List hits = this.getByXpath(".3 <= .4 <= 1.1");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void leftAssociativityOfLessThanOrEqual() throws Exception {
        List hits = this.getByXpath(".3 <= .4 <= 0.9");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void negativeZeroNotEqualsZero() throws Exception {
        List hits = this.getByXpath("0 != -0");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void negativeZeroEqualsZero() throws Exception {
        List hits = this.getByXpath("0 = -0");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void zeroGreaterThanOrEqualsToNegativeZero() throws Exception {
        List hits = this.getByXpath("0 >= -0");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void zeroLessThanOrEqualToNegativeZero() throws Exception {
        List hits = this.getByXpath("0 <= -0");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void negativeZeroNotLessThanZero() throws Exception {
        List hits = this.getByXpath("-0 < 0");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void naNNotEqualsString() throws Exception {
        List hits = this.getByXpath("(0.0 div 0.0) != 'foo'");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.TRUE, hits.get(0));
    }

    @Test
    public void naNEqualsString() throws Exception {
        List hits = this.getByXpath("(0.0 div 0.0) = 'foo'");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }

    @Test
    public void equalityPrecedence() throws Exception {
        List hits = this.getByXpath("1.5 = 2.3 = 2.3");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)Boolean.FALSE, hits.get(0));
    }
}

