/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.Writer;
import net.sourceforge.htmlunit.cyberneko.parsers.DOMParser;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;

public class FragmentContextStackTest
extends TestCase {
    private static final String NL = System.lineSeparator();

    public void testSimple() throws Exception {
        String expected = "(div" + NL + "(span" + NL + "\"hello" + NL + ")span" + NL + ")div" + NL;
        FragmentContextStackTest.doTest("<div><span>hello</span>", new String[]{"html", "body"}, expected);
        FragmentContextStackTest.doTest("<div><span>hello</span>", new String[]{"html"}, expected);
        FragmentContextStackTest.doTest("<div><span>hello</span>", new String[0], expected);
        FragmentContextStackTest.doTest("<div><span>hello</span>", null, expected);
    }

    public void testTR() throws Exception {
        String expected = "(tr" + NL + "(td" + NL + "\"hello" + NL + ")td" + NL + ")tr" + NL;
        FragmentContextStackTest.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body", "table", "tbody"}, expected);
        expected = "(TBODY" + NL + expected + ")TBODY\n";
        FragmentContextStackTest.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body", "table"}, expected);
        FragmentContextStackTest.doTest("<tr><td>hello</td></tr>", new String[]{"html", "body"}, "\"hello");
    }

    public void testFragmentShouldNotCloseContextStack() throws Exception {
        String expected = "\"helloworld\n";
        FragmentContextStackTest.doTest("hello</div>world", new String[]{"html", "body", "div"}, "\"helloworld\n");
        FragmentContextStackTest.doTest("hello</span>world", new String[]{"html", "body", "div", "span"}, "\"helloworld\n");
    }

    private static void doTest(String html, String[] contextStack, String expected) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        if (contextStack != null) {
            parser.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", (Object)FragmentContextStackTest.toQNames(contextStack));
        }
        StringWriter out = new StringWriter();
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Writer(out)};
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
        StringReader sr = new StringReader(html);
        XMLInputSource in = new XMLInputSource(null, "foo", null, (Reader)sr, null);
        parser.parse(in);
        FragmentContextStackTest.assertEquals((String)expected.trim(), (String)out.toString().trim());
    }

    private static QName[] toQNames(String[] tags) {
        QName[] qnames = new QName[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            qnames[i] = new QName(null, tags[i], null, null);
        }
        return qnames;
    }
}

