/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLEntitiesParser;
import org.apache.xerces.xni.parser.XMLInputSource;

public class HTMLEntitiesTest
extends TestCase {
    public void testParseEuml() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "Euml ";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        HTMLEntitiesTest.assertEquals((String)"\u00cb", (String)parser.getMatch());
        HTMLEntitiesTest.assertEquals((int)1, (int)parser.getRewindCount());
        HTMLEntitiesTest.assertFalse((boolean)parser.endsWithSemicolon());
    }

    public void testParseEuml_() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "Euml; ";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        HTMLEntitiesTest.assertEquals((String)"\u00cb", (String)parser.getMatch());
        HTMLEntitiesTest.assertEquals((int)0, (int)parser.getRewindCount());
        HTMLEntitiesTest.assertTrue((boolean)parser.endsWithSemicolon());
    }

    public void testParseEumlX() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "EumlX";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        HTMLEntitiesTest.assertEquals((String)"\u00cb", (String)parser.getMatch());
        HTMLEntitiesTest.assertEquals((int)1, (int)parser.getRewindCount());
        HTMLEntitiesTest.assertFalse((boolean)parser.endsWithSemicolon());
    }

    public void testParseEumX() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "EumX";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        HTMLEntitiesTest.assertNull((Object)parser.getMatch());
        HTMLEntitiesTest.assertEquals((int)4, (int)parser.getRewindCount());
        HTMLEntitiesTest.assertFalse((boolean)parser.endsWithSemicolon());
    }

    public void testParseEuroLt() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "euro<";
        int i = 0;
        while (parser.parse((int)input.charAt(i))) {
            ++i;
        }
        HTMLEntitiesTest.assertNull((Object)parser.getMatch());
        HTMLEntitiesTest.assertEquals((int)5, (int)parser.getRewindCount());
        HTMLEntitiesTest.assertFalse((boolean)parser.endsWithSemicolon());
    }

    public void testParseEuro() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "x80;";
        int i = 0;
        while (parser.parseNumeric((int)input.charAt(i))) {
            ++i;
        }
        HTMLEntitiesTest.assertEquals((String)"\u20ac", (String)parser.getMatch());
        HTMLEntitiesTest.assertEquals((int)0, (int)parser.getRewindCount());
    }

    public void testParseEuroMissingSemicolon() throws Exception {
        HTMLEntitiesParser parser = new HTMLEntitiesParser();
        String input = "x80<";
        int i = 0;
        while (parser.parseNumeric((int)input.charAt(i))) {
            ++i;
        }
        HTMLEntitiesTest.assertEquals((String)"\u20ac", (String)parser.getMatch());
        HTMLEntitiesTest.assertEquals((int)1, (int)parser.getRewindCount());
    }

    public void testRewind() throws Exception {
        HTMLConfiguration htmlConfiguration = new HTMLConfiguration();
        String content = "<html blah=\"funfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfunfun&fin\"></html>";
        ByteArrayInputStream byteStream = new ByteArrayInputStream(content.getBytes());
        XMLInputSource inputSource = new XMLInputSource("", "", "", (InputStream)byteStream, "UTF-8");
        htmlConfiguration.parse(inputSource);
    }
}

