/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.Writer;
import net.sourceforge.htmlunit.cyberneko.parsers.DOMParser;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.junit.Assert;

public class GeneralTest
extends TestCase {
    private static final String NL = System.lineSeparator();
    private static final String[] FEATURES = new String[]{"http://cyberneko.org/html/features/augmentations"};

    public void testNewlineInAttributeCrLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,52](span" + NL + "Aclass value\\ncontaining a newline" + NL + "[2,23,52;2,34,63]\"spancontent" + NL + "[2,34,63;2,41,70])span" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <span class='value\r\ncontaining a newline'>spancontent</span>", new String[]{"html", "body"}, expected, FEATURES);
    }

    public void testNewlineInAttributeLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,51](span" + NL + "Aclass value\\ncontaining a newline" + NL + "[2,23,51;2,34,62]\"spancontent" + NL + "[2,34,62;2,41,69])span" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <span class='value\ncontaining a newline'>spancontent</span>", new String[]{"html", "body"}, expected, FEATURES);
    }

    public void testNewlineInPiCrLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,63]?instruct beforenl='content'\\n  afternl=\"content\" " + NL + "[2,23,63;3,1,74]\"more text\\n" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <?instruct beforenl='content'\r\n  afternl=\"content\" ?>more text\r\n", new String[]{"html", "body"}, expected, FEATURES);
    }

    public void testNewlineInPiLf() throws Exception {
        String expected = "[synth](HTML" + NL + "[synth](head" + NL + "[synth])head" + NL + "[synth](body" + NL + "[1,1,0;1,11,10]\"some text " + NL + "[1,11,10;2,23,62]?instruct beforenl='content'\\n  afternl=\"content\" " + NL + "[2,23,62;3,1,73]\"more text\\n" + NL + "[synth])body" + NL + "[synth])HTML" + NL;
        GeneralTest.doTest("some text <?instruct beforenl='content'\n  afternl=\"content\" ?>more text\r\n", new String[]{"html", "body"}, expected, FEATURES);
    }

    public static void doTest(String html, String[] contextStack, String expected, String ... features) throws Exception {
        DOMParser parser = new DOMParser();
        for (String feature : features) {
            parser.setFeature(feature, true);
        }
        if (contextStack != null) {
            parser.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", (Object)GeneralTest.toQNames(contextStack));
        }
        StringWriter out = new StringWriter();
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Writer(out)};
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
        StringReader sr = new StringReader(html);
        XMLInputSource in = new XMLInputSource(null, "foo", null, (Reader)sr, null);
        parser.parse(in);
        Assert.assertEquals((Object)expected.trim(), (Object)out.toString().trim());
    }

    private static QName[] toQNames(String[] tags) {
        QName[] qnames = new QName[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            qnames[i] = new QName(null, tags[i], null, null);
        }
        return qnames;
    }
}

