/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UTF8BOMSkipper
extends FilterInputStream {
    private boolean fStart = true;
    private int fOffset;
    private int[] fFirst3Bytes;

    public UTF8BOMSkipper(InputStream stream) {
        super(stream);
    }

    @Override
    public int read() throws IOException {
        if (this.fStart) {
            this.fStart = false;
            int b1 = super.read();
            int b2 = super.read();
            int b3 = super.read();
            if (b1 != 239 || b2 != 187 || b3 != 191) {
                this.fFirst3Bytes = new int[3];
                this.fFirst3Bytes[0] = b1;
                this.fFirst3Bytes[1] = b2;
                this.fFirst3Bytes[2] = b3;
            }
        }
        if (this.fFirst3Bytes != null) {
            int b = this.fFirst3Bytes[this.fOffset++];
            if (this.fOffset == this.fFirst3Bytes.length) {
                this.fFirst3Bytes = null;
            }
            return b;
        }
        return super.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.fStart || this.fFirst3Bytes != null) {
            for (int i = 0; i < length; ++i) {
                int b = this.read();
                if (b == -1) {
                    return i > 0 ? i : -1;
                }
                buffer[offset + i] = (byte)b;
            }
            return length;
        }
        return super.read(buffer, offset, length);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        if (this.fFirst3Bytes != null) {
            return this.fFirst3Bytes.length - this.fOffset;
        }
        return super.available();
    }
}

