/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLEventInfo;
import net.sourceforge.htmlunit.cyberneko.filters.DefaultFilter;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;

public class Writer
extends DefaultFilter {
    protected PrintWriter out = new PrintWriter(System.out);
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private boolean fInCharacters = false;
    private int fCharactersBeginLine = -1;
    private int fCharactersBeginColumn = -1;
    private int fCharactersBeginCharacterOffset = -1;
    private int fCharactersEndLine = -1;
    private int fCharactersEndColumn = -1;
    private int fCharactersEndCharacterOffset = -1;

    public Writer() {
        this(System.out);
    }

    public Writer(OutputStream stream) {
        this(stream, "UTF8");
    }

    public Writer(OutputStream stream, String encoding) {
        try {
            this.out = new PrintWriter((java.io.Writer)new OutputStreamWriter(stream, encoding), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM must have " + encoding + " decoder");
        }
    }

    public Writer(java.io.Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext nscontext, Augmentations augs) throws XNIException {
        this.fStringBuffer.clear();
    }

    public void endDocument(Augmentations augs) throws XNIException {
        this.chars();
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        this.doAugs(augs);
        if (version != null) {
            this.out.print("xversion ");
            this.out.println(version);
        }
        if (encoding != null) {
            this.out.print("xencoding ");
            this.out.println(encoding);
        }
        if (standalone != null) {
            this.out.print("xstandalone ");
            this.out.println(standalone);
        }
        this.out.flush();
    }

    public void doctypeDecl(String root, String pubid, String sysid, Augmentations augs) throws XNIException {
        this.chars();
        this.doAugs(augs);
        this.out.print('!');
        if (root != null) {
            this.out.print(root);
        }
        this.out.println();
        if (pubid != null) {
            this.out.print('p');
            this.out.print(pubid);
            this.out.println();
        }
        if (sysid != null) {
            this.out.print('s');
            this.out.print(sysid);
            this.out.println();
        }
        this.out.flush();
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        this.chars();
        this.doAugs(augs);
        this.out.print('?');
        this.out.print(target);
        if (data != null && data.length > 0) {
            this.out.print(' ');
            this.print(data.toString());
        }
        this.out.println();
        this.out.flush();
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        this.chars();
        this.doAugs(augs);
        this.out.print('#');
        this.print(text.toString());
        this.out.println();
        this.out.flush();
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        int acount;
        this.chars();
        this.doAugs(augs);
        this.out.print('(');
        this.out.print(element.rawname);
        if (attrs != null && (acount = attrs.getLength()) > 0) {
            String[] anames = new String[acount];
            String[] auris = new String[acount];
            Writer.sortAttrNames(attrs, anames, auris);
            for (int i = 0; i < acount; ++i) {
                String aname = anames[i];
                this.out.println();
                this.out.flush();
                this.out.print('A');
                if (auris[i] != null) {
                    this.out.print('{');
                    this.out.print(auris[i]);
                    this.out.print('}');
                }
                this.out.print(aname);
                this.out.print(' ');
                this.print(attrs.getValue(aname));
            }
        }
        this.out.println();
        this.out.flush();
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.chars();
        this.doAugs(augs);
        this.out.print(')');
        this.out.print(element.rawname);
        this.out.println();
        this.out.flush();
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        this.startElement(element, attrs, augs);
        this.endElement(element, augs);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        this.storeCharactersEnd(augs);
        if (!this.fInCharacters) {
            this.storeCharactersStart(augs);
        }
        this.fInCharacters = true;
        this.fStringBuffer.append(text);
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.characters(text, augs);
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.chars();
        this.doAugs(augs);
        this.out.println("((CDATA");
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.chars();
        this.doAugs(augs);
        this.out.println("))CDATA");
        this.out.flush();
    }

    protected void chars() {
        this.fInCharacters = false;
        if (this.fStringBuffer.length == 0) {
            return;
        }
        this.doCharactersAugs();
        this.out.print('\"');
        this.print(this.fStringBuffer.toString());
        this.out.println();
        this.out.flush();
        this.fStringBuffer.clear();
    }

    protected void print(String s) {
        if (s != null) {
            int length = s.length();
            block6: for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\n': {
                        this.out.print("\\n");
                        continue block6;
                    }
                    case '\r': {
                        this.out.print("\\r");
                        continue block6;
                    }
                    case '\t': {
                        this.out.print("\\t");
                        continue block6;
                    }
                    case '\\': {
                        this.out.print("\\\\");
                        continue block6;
                    }
                    default: {
                        this.out.print(c);
                    }
                }
            }
        }
    }

    protected void doAugs(Augmentations augs) {
        HTMLEventInfo evInfo;
        HTMLEventInfo hTMLEventInfo = evInfo = augs == null ? null : (HTMLEventInfo)augs.getItem("http://cyberneko.org/html/features/augmentations");
        if (evInfo != null) {
            if (evInfo.isSynthesized()) {
                this.out.print("[synth]");
            } else {
                this.out.print('[');
                this.out.print(evInfo.getBeginLineNumber());
                this.out.print(',');
                this.out.print(evInfo.getBeginColumnNumber());
                this.out.print(',');
                this.out.print(evInfo.getBeginCharacterOffset());
                this.out.print(';');
                this.out.print(evInfo.getEndLineNumber());
                this.out.print(',');
                this.out.print(evInfo.getEndColumnNumber());
                this.out.print(',');
                this.out.print(evInfo.getEndCharacterOffset());
                this.out.print(']');
            }
        }
    }

    protected void storeCharactersStart(Augmentations augs) {
        HTMLEventInfo evInfo;
        HTMLEventInfo hTMLEventInfo = evInfo = augs == null ? null : (HTMLEventInfo)augs.getItem("http://cyberneko.org/html/features/augmentations");
        if (evInfo != null) {
            this.fCharactersBeginLine = evInfo.getBeginLineNumber();
            this.fCharactersBeginColumn = evInfo.getBeginColumnNumber();
            this.fCharactersBeginCharacterOffset = evInfo.getBeginCharacterOffset();
        }
    }

    protected void storeCharactersEnd(Augmentations augs) {
        HTMLEventInfo evInfo;
        HTMLEventInfo hTMLEventInfo = evInfo = augs == null ? null : (HTMLEventInfo)augs.getItem("http://cyberneko.org/html/features/augmentations");
        if (evInfo != null) {
            this.fCharactersEndLine = evInfo.getEndLineNumber();
            this.fCharactersEndColumn = evInfo.getEndColumnNumber();
            this.fCharactersEndCharacterOffset = evInfo.getEndCharacterOffset();
        }
    }

    protected void doCharactersAugs() {
        if (this.fCharactersBeginLine >= 0) {
            this.out.print('[');
            this.out.print(this.fCharactersBeginLine);
            this.out.print(',');
            this.out.print(this.fCharactersBeginColumn);
            this.out.print(',');
            this.out.print(this.fCharactersBeginCharacterOffset);
            this.out.print(';');
            this.out.print(this.fCharactersEndLine);
            this.out.print(',');
            this.out.print(this.fCharactersEndColumn);
            this.out.print(',');
            this.out.print(this.fCharactersEndCharacterOffset);
            this.out.print(']');
        }
    }

    protected static void sortAttrNames(XMLAttributes attrs, String[] anames, String[] auris) {
        int i;
        for (i = 0; i < anames.length; ++i) {
            anames[i] = attrs.getQName(i);
            auris[i] = attrs.getURI(i);
        }
        for (i = 0; i < anames.length - 1; ++i) {
            int index = i;
            for (int j = i + 1; j < anames.length; ++j) {
                if (anames[j].compareTo(anames[index]) >= 0) continue;
                index = j;
            }
            if (index == i) continue;
            String tn = anames[i];
            anames[i] = anames[index];
            anames[index] = tn;
            String tu = auris[i];
            auris[i] = auris[index];
            auris[index] = tu;
        }
    }

    public static void main(String[] argv) throws Exception {
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Writer()};
        HTMLConfiguration parser = new HTMLConfiguration();
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
        for (String element : argv) {
            XMLInputSource source = new XMLInputSource(null, element, null);
            parser.parse(source);
        }
    }
}

