/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.StringReader;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.cyberneko.parsers.DOMFragmentParser;
import org.apache.html.dom.HTMLDocumentImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class DOMFragmentParserTest
extends TestCase {
    public void testAttrEndingWithCRAtEndOfStream() throws Exception {
    }

    public void testInvalidProcessingInstruction() throws Exception {
        DOMFragmentParserTest.doTest("<html><?9 ?></html>", "<HTML/>");
    }

    public void testInvalidAttributeName() throws Exception {
        DOMFragmentParserTest.doTest("<html 9='id'></html>", "<HTML/>");
    }

    private static void doTest(String html, String expected) throws Exception {
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocumentImpl document = new HTMLDocumentImpl();
        DocumentFragment fragment = document.createDocumentFragment();
        InputSource source = new InputSource(new StringReader(html));
        parser.parse(source, fragment);
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        String str = writer.writeToString(fragment);
        String xmlDecl = "<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n";
        DOMFragmentParserTest.assertEquals((String)("<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n" + expected), (String)str);
    }

    public static void print(Node node, String indent) {
        System.out.println(indent + node.getClass().getName());
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DOMFragmentParserTest.print(child, indent + " ");
        }
    }

    public void testInstanceReuse() throws Exception {
        String s = "<html><body><frame><frameset></frameset></html>";
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocumentImpl document = new HTMLDocumentImpl();
        DocumentFragment fragment1 = document.createDocumentFragment();
        parser.parse(new InputSource(new StringReader("<html><body><frame><frameset></frameset></html>")), fragment1);
        DocumentFragment fragment2 = document.createDocumentFragment();
        parser.parse(new InputSource(new StringReader("<html><body><frame><frameset></frameset></html>")), fragment2);
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        String str1 = writer.writeToString(fragment1);
        String str2 = writer.writeToString(fragment2);
        DOMFragmentParserTest.assertEquals((String)str1, (String)str2);
    }
}

