/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.benchmarks;

import jadex.bridge.CreationInfo;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.IArgument;
import jadex.bridge.service.IServiceProvider;
import jadex.bridge.service.SServiceProvider;
import jadex.bridge.service.clock.IClockService;
import jadex.commons.Tuple;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.IMicroExternalAccess;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import jadex.xml.annotation.XMLClassname;
import java.util.HashMap;
import java.util.Map;

public class AgentCreationAgent
extends MicroAgent {
    public void executeBody() {
        HashMap args;
        HashMap arguments = this.getArguments();
        if (arguments == null) {
            arguments = new HashMap();
        }
        if ((args = arguments).get("num") == null) {
            this.getClock().addResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object result) {
                    System.gc();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    Long startmem = new Long(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                    Long starttime = new Long(((IClockService)result).getTime());
                    args.put("num", new Integer(1));
                    args.put("startmem", startmem);
                    args.put("starttime", starttime);
                    AgentCreationAgent.this.step1(args);
                }
            });
        } else {
            this.step1(args);
        }
    }

    protected void step1(final Map args) {
        final int num = (Integer)args.get("num");
        final int max = (Integer)args.get("max");
        final boolean nested = (Boolean)args.get("nested");
        System.out.println("Created peer: " + num);
        if (num < max) {
            args.put("num", new Integer(num + 1));
            this.getCMS().addResultListener(this.createResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object result) {
                    ((IComponentManagementService)result).createComponent(AgentCreationAgent.this.createPeerName(num + 1, AgentCreationAgent.this.getComponentIdentifier()), ((Object)((Object)AgentCreationAgent.this)).getClass().getName().replaceAll("\\.", "/") + ".class", new CreationInfo(args, nested ? AgentCreationAgent.this.getComponentIdentifier() : null), null);
                }
            }));
        } else {
            this.getClock().addResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object result) {
                    final IClockService clock = (IClockService)result;
                    long end = clock.getTime();
                    System.gc();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    Long startmem = (Long)args.get("startmem");
                    Long starttime = (Long)args.get("starttime");
                    final long omem = (used - startmem) / 1024L;
                    final double upera = (double)(1000L * (used - startmem) / (long)max / 1024L) / 1000.0;
                    System.out.println("Overall memory usage: " + omem + "kB. Per agent: " + upera + " kB.");
                    System.out.println("Last peer created. " + max + " agents started.");
                    final double dur = ((double)end - (double)starttime.longValue()) / 1000.0;
                    final double pera = dur / (double)max;
                    System.out.println("Needed: " + dur + " secs. Per agent: " + pera + " sec. Corresponds to " + 1.0 / pera + " agents per sec.");
                    AgentCreationAgent.this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

                        public void resultAvailable(Object result) {
                            IComponentManagementService cms = (IComponentManagementService)result;
                            String initial = AgentCreationAgent.this.createPeerName(1, AgentCreationAgent.this.getComponentIdentifier());
                            IComponentIdentifier cid = cms.createComponentIdentifier(initial, true);
                            cms.getExternalAccess(cid).addResultListener(AgentCreationAgent.this.createResultListener((IResultListener)new DefaultResultListener(){

                                public void resultAvailable(Object result) {
                                    IMicroExternalAccess exta = (IMicroExternalAccess)result;
                                    exta.scheduleStep(new IComponentStep(){

                                        @XMLClassname(value="deletePeers")
                                        public Object execute(IInternalAccess ia) {
                                            ((AgentCreationAgent)ia).deletePeers(max, clock.getTime(), dur, pera, omem, upera, max, nested);
                                            return null;
                                        }
                                    });
                                }
                            }));
                        }
                    });
                }
            });
        }
    }

    protected String createPeerName(int num, IComponentIdentifier cid) {
        String name = cid.getLocalName();
        int index = name.indexOf("Peer_#");
        if (index != -1) {
            name = name.substring(0, index);
        }
        if (num != 1) {
            name = name + "Peer_#" + num;
        }
        return name;
    }

    protected void deletePeers(final int cnt, final long killstarttime, final double dur, final double pera, final long omem, final double upera, final int max, final boolean nested) {
        final String name = this.createPeerName(cnt, this.getComponentIdentifier());
        this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                IComponentIdentifier aid = cms.createComponentIdentifier(name, true, null);
                cms.destroyComponent(aid).addResultListener(AgentCreationAgent.this.createResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        System.out.println("Successfully destroyed peer: " + name);
                        if (cnt - 1 > (nested ? 1 : 1)) {
                            AgentCreationAgent.this.deletePeers(cnt - 1, killstarttime, dur, pera, omem, upera, max, nested);
                        } else {
                            AgentCreationAgent.this.killLastPeer(max, killstarttime, dur, pera, omem, upera);
                        }
                    }
                }));
            }
        });
    }

    protected void killLastPeer(final int max, final long killstarttime, final double dur, final double pera, final long omem, final double upera) {
        this.getClock().addResultListener(this.createResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IClockService cs = (IClockService)result;
                long killend = cs.getTime();
                System.out.println("Last peer destroyed. " + (max - 1) + " agents killed.");
                double killdur = ((double)killend - (double)killstarttime) / 1000.0;
                double killpera = killdur / (double)(max - 1);
                Runtime.getRuntime().gc();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long stillused = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
                System.out.println("\nCumulated results:");
                System.out.println("Creation needed: " + dur + " secs. Per agent: " + pera + " sec. Corresponds to " + 1.0 / pera + " agents per sec.");
                System.out.println("Killing needed:  " + killdur + " secs. Per agent: " + killpera + " sec. Corresponds to " + 1.0 / killpera + " agents per sec.");
                System.out.println("Overall memory usage: " + omem + "kB. Per agent: " + upera + " kB.");
                System.out.println("Still used memory: " + stillused + "kB.");
                AgentCreationAgent.this.setResultValue("microcreationtime", new Tuple((Object)("" + pera), (Object)"s"));
                AgentCreationAgent.this.setResultValue("microkillingtime", new Tuple((Object)("" + killpera), (Object)"s"));
                AgentCreationAgent.this.setResultValue("micromem", new Tuple((Object)("" + upera), (Object)"kb"));
                AgentCreationAgent.this.killComponent();
            }
        }));
    }

    protected IFuture getCMS() {
        IFuture ret = null;
        if (ret == null) {
            ret = SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), IComponentManagementService.class);
        }
        return ret;
    }

    protected IFuture getClock() {
        IFuture ret = null;
        if (ret == null) {
            ret = SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), IClockService.class);
        }
        return ret;
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("This agents benchmarks agent creation and termination.", new String[0], new IArgument[]{new Argument("max", "Maximum number of agents to create.", "Integer", new Integer(10000)){

            @XMLClassname(value="argument")
            public boolean validate(String input) {
                boolean ret = true;
                try {
                    Integer.parseInt(input);
                }
                catch (Exception e) {
                    ret = false;
                }
                return ret;
            }
        }, new Argument("nested", "If true, each agent is created as a subcomponent of the previous agent.", "boolean", (Object)Boolean.FALSE)}, null, null, null, null, null);
    }
}

