/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.benchmarks;

import jadex.bridge.CreationInfo;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.service.clock.IClockService;
import jadex.commons.Tuple;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.benchmarks.MegaParallelCreationAgent;
import java.util.HashMap;

@Arguments(value={@Argument(name="max", defaultvalue="20000", clazz=int.class)})
public class MegaParallelStarterAgent
extends MicroAgent {
    protected String subname;
    protected int agents;
    protected long startmem;
    protected long starttime;
    protected long omem;
    protected double dur;
    protected double pera;
    protected double upera;
    protected long killstarttime;

    public void executeBody() {
        HashMap arguments = this.getArguments();
        if (arguments == null) {
            arguments = new HashMap();
        }
        final HashMap args = arguments;
        System.out.println("Created starter: " + this.getComponentIdentifier());
        this.subname = "peer";
        this.getClock().addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                MegaParallelStarterAgent.this.startmem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                MegaParallelStarterAgent.this.starttime = ((IClockService)result).getTime();
                final int max = (Integer)args.get("max");
                MegaParallelStarterAgent.this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        String model = MegaParallelCreationAgent.class.getName().replaceAll("\\.", "/") + ".class";
                        for (int i = 1; i <= max; ++i) {
                            args.put("num", new Integer(i));
                            cms.createComponent(MegaParallelStarterAgent.this.subname + "_#" + i, model, new CreationInfo(new HashMap(args), MegaParallelStarterAgent.this.getComponentIdentifier()), MegaParallelStarterAgent.this.createResultListener((IResultListener)new DefaultResultListener(){

                                public void resultAvailable(Object result) {
                                    if (--MegaParallelStarterAgent.this.agents == 0) {
                                        MegaParallelStarterAgent.this.getClock().addResultListener((IResultListener)new DefaultResultListener(){

                                            public void resultAvailable(Object result) {
                                                IClockService cs = (IClockService)result;
                                                long killend = cs.getTime();
                                                System.out.println("Last peer destroyed. " + (max - 1) + " agents killed.");
                                                double killdur = ((double)killend - (double)MegaParallelStarterAgent.this.killstarttime) / 1000.0;
                                                double killpera = killdur / (double)(max - 1);
                                                long stillused = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
                                                System.out.println("\nCumulated results:");
                                                System.out.println("Creation needed: " + MegaParallelStarterAgent.this.dur + " secs. Per agent: " + MegaParallelStarterAgent.this.pera + " sec. Corresponds to " + 1.0 / MegaParallelStarterAgent.this.pera + " agents per sec.");
                                                System.out.println("Killing needed:  " + killdur + " secs. Per agent: " + killpera + " sec. Corresponds to " + 1.0 / killpera + " agents per sec.");
                                                System.out.println("Overall memory usage: " + MegaParallelStarterAgent.this.omem + "kB. Per agent: " + MegaParallelStarterAgent.this.upera + " kB.");
                                                System.out.println("Still used memory: " + stillused + "kB.");
                                                MegaParallelStarterAgent.this.setResultValue("microcreationtime", new Tuple((Object)("" + MegaParallelStarterAgent.this.pera), (Object)"s"));
                                                MegaParallelStarterAgent.this.setResultValue("microkillingtime", new Tuple((Object)("" + killpera), (Object)"s"));
                                                MegaParallelStarterAgent.this.setResultValue("micromem", new Tuple((Object)("" + MegaParallelStarterAgent.this.upera), (Object)"kb"));
                                                MegaParallelStarterAgent.this.killComponent();
                                            }
                                        });
                                    }
                                }
                            })).addResultListener(MegaParallelStarterAgent.this.createResultListener((IResultListener)new DefaultResultListener(){

                                public void resultAvailable(Object result) {
                                    if (++MegaParallelStarterAgent.this.agents == max) {
                                        MegaParallelStarterAgent.this.getClock().addResultListener((IResultListener)new DefaultResultListener(){

                                            public void resultAvailable(Object result) {
                                                IClockService clock = (IClockService)result;
                                                long end = clock.getTime();
                                                long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                                                MegaParallelStarterAgent.this.omem = (used - MegaParallelStarterAgent.this.startmem) / 1024L;
                                                MegaParallelStarterAgent.this.upera = (double)(1000L * (used - MegaParallelStarterAgent.this.startmem / (long)max / 1024L)) / 1000.0;
                                                System.out.println("Overall memory usage: " + MegaParallelStarterAgent.this.omem + "kB. Per agent: " + MegaParallelStarterAgent.this.upera + " kB.");
                                                System.out.println("Last peer created. " + max + " agents started.");
                                                MegaParallelStarterAgent.this.dur = ((double)end - (double)MegaParallelStarterAgent.this.starttime) / 1000.0;
                                                MegaParallelStarterAgent.this.pera = MegaParallelStarterAgent.this.dur / (double)max;
                                                System.out.println("Needed: " + MegaParallelStarterAgent.this.dur + " secs. Per agent: " + MegaParallelStarterAgent.this.pera + " sec. Corresponds to " + 1.0 / MegaParallelStarterAgent.this.pera + " agents per sec.");
                                                MegaParallelStarterAgent.this.killstarttime = clock.getTime();
                                                MegaParallelStarterAgent.this.deletePeers(max);
                                            }
                                        });
                                    }
                                }
                            }));
                        }
                    }
                });
            }
        });
    }

    protected void deletePeers(final int cnt) {
        final String name = this.subname + "_#" + cnt;
        this.getCMS().addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                IComponentIdentifier aid = cms.createComponentIdentifier(name, MegaParallelStarterAgent.this.getComponentIdentifier(), null);
                IResultListener lis = new IResultListener(){

                    public void resultAvailable(Object result) {
                        System.out.println("Successfully destroyed peer: " + name);
                        if (cnt > 1) {
                            MegaParallelStarterAgent.this.deletePeers(cnt - 1);
                        }
                    }

                    public void exceptionOccurred(Exception exception) {
                        exception.printStackTrace();
                    }
                };
                IFuture ret = cms.destroyComponent(aid);
                ret.addResultListener(lis);
            }
        });
    }

    protected IFuture getCMS() {
        IFuture cms = null;
        if (cms == null) {
            cms = this.getServiceContainer().searchServiceUpwards(IComponentManagementService.class);
        }
        return cms;
    }

    protected IFuture getClock() {
        IFuture clock = null;
        if (clock == null) {
            clock = this.getServiceContainer().searchServiceUpwards(IClockService.class);
        }
        return clock;
    }
}

