/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.benchmarks;

import jadex.base.fipa.SFipa;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.MessageType;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.IArgument;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import jadex.micro.benchmarks.Message;
import java.util.HashMap;
import java.util.Map;

public class MessagePerformanceAgent
extends MicroAgent {
    protected int received;
    protected long starttime;
    protected int current;

    public void executeBody() {
        this.getTime().addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                MessagePerformanceAgent.this.current = 1;
                MessagePerformanceAgent.this.starttime = (Long)result;
                final int msgcnt = (Integer)MessagePerformanceAgent.this.getArgument("max");
                final IComponentIdentifier receiver = MessagePerformanceAgent.this.getComponentIdentifier();
                final boolean usecodec = (Boolean)MessagePerformanceAgent.this.getArgument("codec");
                IComponentStep send = new IComponentStep(){

                    public Object execute(IInternalAccess ia) {
                        int i;
                        if (MessagePerformanceAgent.this.current == 1) {
                            System.out.println("Now sending " + msgcnt + " messages to " + receiver);
                            System.out.println("Codec is: " + usecodec);
                        }
                        for (i = MessagePerformanceAgent.this.current; i <= msgcnt; ++i) {
                            HashMap<String, Object> request = new HashMap<String, Object>();
                            request.put("performative", "inform");
                            request.put("receivers", new IComponentIdentifier[]{receiver});
                            request.put("reply_with", "some reply id");
                            if (!usecodec) {
                                request.put("content", "message: " + i);
                            } else {
                                request.put("language", "jadex-xml");
                                request.put("content", new Message("message: " + i, true));
                            }
                            MessagePerformanceAgent.this.sendMessage(request, SFipa.FIPA_MESSAGE_TYPE);
                            if (i <= 0 || i % 10 != 0) continue;
                            System.out.print('.');
                            if (i % 1000 != 0) continue;
                            System.out.println();
                            break;
                        }
                        MessagePerformanceAgent.this.current = i + 1;
                        if (MessagePerformanceAgent.this.current <= msgcnt) {
                            MessagePerformanceAgent.this.waitFor(0L, this);
                        }
                        return null;
                    }
                };
                send.execute((IInternalAccess)MessagePerformanceAgent.this);
            }
        });
    }

    public void messageArrived(Map msg, MessageType mt) {
        ++this.received;
        final int msgcnt = (Integer)this.getArgument("max");
        if (this.received == msgcnt) {
            this.getTime().addResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object result) {
                    long dur = (Long)result - MessagePerformanceAgent.this.starttime;
                    System.out.println("Sending/receiving " + msgcnt + " messages took: " + dur + " milliseconds.");
                    MessagePerformanceAgent.this.killAgent();
                }
            });
        }
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("This agents benchmarks agent message sending.", new String[0], new IArgument[]{new Argument("max", "Maximum number of messages to send.", "Integer", new Integer(1000)){

            public boolean validate(String input) {
                boolean ret = true;
                try {
                    Integer.parseInt(input);
                }
                catch (Exception e) {
                    ret = false;
                }
                return ret;
            }
        }, new Argument("codec", "Use content codec for message content.", "boolean", Boolean.FALSE){

            public boolean validate(String input) {
                boolean ret = true;
                try {
                    Boolean.valueOf(input);
                }
                catch (Exception e) {
                    ret = false;
                }
                return ret;
            }
        }}, null, null, null);
    }
}

