/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.benchmarks;

import jadex.bridge.CreationInfo;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.IArgument;
import jadex.bridge.service.clock.IClockService;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import jadex.xml.annotation.XMLClassname;
import java.util.HashMap;
import java.util.Map;

public class ParallelAgentCreationAgent
extends MicroAgent {
    public void executeBody() {
        Map arguments = this.getArguments();
        final int num = (Integer)arguments.get("num");
        if (num > 0) {
            this.getServiceContainer().searchServiceUpwards(IComponentManagementService.class).addResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object result) {
                    final IComponentManagementService cms = (IComponentManagementService)result;
                    ParallelAgentCreationAgent.this.getServiceContainer().searchService(IClockService.class).addResultListener((IResultListener)new DefaultResultListener(){

                        public void resultAvailable(Object result) {
                            final IClockService clock = (IClockService)result;
                            final long startmem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                            final long starttime = clock.getTime();
                            final long[] omem = new long[1];
                            final double[] dur = new double[1];
                            final long[] killstarttime = new long[1];
                            CounterResultListener creationlis = new CounterResultListener(num, new IResultListener(){

                                public void resultAvailable(Object result) {
                                    ParallelAgentCreationAgent.this.scheduleStep(new IComponentStep(){

                                        @XMLClassname(value="destroy1")
                                        public Object execute(IInternalAccess ia) {
                                            long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                                            omem[0] = (used - startmem) / 1024L;
                                            double upera = (double)(1000L * omem[0] / (long)num) / 1000.0;
                                            System.out.println("Overall memory usage: " + omem[0] + "kB. Per agent: " + upera + " kB.");
                                            long end = clock.getTime();
                                            System.out.println("Last peer created. " + num + " agents started.");
                                            dur[0] = ((double)end - (double)starttime) / 1000.0;
                                            double pera = dur[0] / (double)num;
                                            System.out.println("Needed: " + dur[0] + " secs. Per agent: " + pera + " sec. Corresponds to " + 1.0 / pera + " agents per sec.");
                                            killstarttime[0] = clock.getTime();
                                            for (int i = num; i > 0; --i) {
                                                String name = ParallelAgentCreationAgent.this.createPeerName(i);
                                                IComponentIdentifier cid = cms.createComponentIdentifier(name, true, null);
                                                cms.destroyComponent(cid);
                                            }
                                            return null;
                                        }
                                    });
                                }

                                public void exceptionOccurred(final Exception exception) {
                                    ParallelAgentCreationAgent.this.scheduleStep(new IComponentStep(){

                                        @XMLClassname(value="destroy2")
                                        public Object execute(IInternalAccess ia) {
                                            if (exception instanceof RuntimeException) {
                                                throw (RuntimeException)exception;
                                            }
                                            throw new RuntimeException(exception);
                                        }
                                    });
                                }
                            }){

                                public void intermediateResultAvailable(Object result) {
                                    System.out.println("Created peer: " + this.getCnt());
                                }
                            };
                            CounterResultListener killlis = new CounterResultListener(num, new IResultListener(){

                                public void resultAvailable(Object result) {
                                    ParallelAgentCreationAgent.this.scheduleStep(new IComponentStep(){

                                        @XMLClassname(value="last")
                                        public Object execute(IInternalAccess ia) {
                                            long killend = clock.getTime();
                                            System.out.println("Last peer destroyed. " + num + " agents killed.");
                                            double killdur = ((double)killend - (double)killstarttime[0]) / 1000.0;
                                            double killpera = killdur / (double)num;
                                            Runtime.getRuntime().gc();
                                            long stillused = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
                                            double pera = dur[0] / (double)num;
                                            double upera = (double)(1000L * omem[0] / (long)num) / 1000.0;
                                            System.out.println("\nCumulated results:");
                                            System.out.println("Creation needed: " + dur[0] + " secs. Per agent: " + pera + " sec. Corresponds to " + 1.0 / pera + " agents per sec.");
                                            System.out.println("Killing needed:  " + killdur + " secs. Per agent: " + killpera + " sec. Corresponds to " + 1.0 / killpera + " agents per sec.");
                                            System.out.println("Overall memory usage: " + omem[0] + "kB. Per agent: " + upera + " kB.");
                                            System.out.println("Still used memory: " + stillused + "kB.");
                                            ParallelAgentCreationAgent.this.killAgent();
                                            return null;
                                        }
                                    });
                                }

                                public void exceptionOccurred(final Exception exception) {
                                    ParallelAgentCreationAgent.this.scheduleStep(new IComponentStep(){

                                        @XMLClassname(value="destroyMe")
                                        public Object execute(IInternalAccess ia) {
                                            if (exception instanceof RuntimeException) {
                                                throw (RuntimeException)exception;
                                            }
                                            throw new RuntimeException(exception);
                                        }
                                    });
                                }
                            }){

                                public void intermediateResultAvailable(Object result) {
                                    System.out.println("Successfully destroyed peer: " + result);
                                }
                            };
                            HashMap<String, Integer> args = new HashMap<String, Integer>();
                            args.put("num", new Integer(0));
                            CreationInfo cinfo = new CreationInfo(args);
                            for (int i = 1; i <= num; ++i) {
                                cms.createComponent(ParallelAgentCreationAgent.this.createPeerName(i), ((Object)((Object)ParallelAgentCreationAgent.this)).getClass().getName() + ".class", cinfo, (IResultListener)killlis).addResultListener((IResultListener)creationlis);
                            }
                        }
                    });
                }
            });
        }
    }

    protected String createPeerName(int num) {
        return this.getComponentIdentifier().getLocalName() + "Peer_#" + num;
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("This agents benchmarks parallel agent creation and termination.", new String[0], new IArgument[]{new Argument("num", "Number of agents to create.", "Integer", new Integer(10000)){

            public boolean validate(String input) {
                boolean ret = true;
                try {
                    Integer.parseInt(input);
                }
                catch (Exception e) {
                    ret = false;
                }
                return ret;
            }
        }}, null, null, null);
    }
}

