/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.benchmarks;

import jadex.bridge.CreationInfo;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.IArgument;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import java.util.HashMap;

public class TreeStressTestAgent
extends MicroAgent {
    public void executeBody() {
        this.getServiceContainer().searchServiceUpwards(IComponentManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                int depth = ((Number)TreeStressTestAgent.this.getArgument("depth")).intValue();
                if (depth > 0) {
                    HashMap<String, Integer> args = new HashMap<String, Integer>();
                    args.put("depth", new Integer(depth - 1));
                    CreationInfo ci = new CreationInfo(args, TreeStressTestAgent.this.getComponentIdentifier());
                    for (int i = 0; i < depth; ++i) {
                        cms.createComponent(null, ((Object)((Object)TreeStressTestAgent.this)).getClass().getName() + ".class", ci, null).addResultListener((IResultListener)new DefaultResultListener(){

                            public void resultAvailable(Object result) {
                            }
                        });
                    }
                }
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("<h1>Tree Stress Test</h1>Creates a complex tree structure of sub components.", null, new IArgument[]{new Argument("depth", "Depth of the tree.", "int", (Object)new Integer(5))}, null);
    }
}

