/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.chat;

import jadex.bridge.IComponentListener;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.TerminationAdapter;
import jadex.commons.ChangeEvent;
import jadex.commons.IRemoteChangeListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.micro.examples.chat.IChatService;
import jadex.xml.annotation.XMLClassname;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ChatPanel
extends JPanel {
    public static final String lf = System.getProperty("line.separator");
    protected IExternalAccess agent;
    protected JTextArea chatarea;

    public ChatPanel(final IExternalAccess agent) {
        this.agent = agent;
        this.chatarea = new JTextArea(10, 30);
        JScrollPane main = new JScrollPane(this.chatarea);
        JPanel south = new JPanel(new BorderLayout());
        final JTextField tf = new JTextField();
        JButton send = new JButton("Send");
        south.add((Component)tf, "Center");
        south.add((Component)send, "East");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatPanel.this.tell("" + agent.getComponentIdentifier(), tf.getText());
                tf.setText("");
            }
        };
        tf.addActionListener(al);
        send.addActionListener(al);
        agent.scheduleStep(new IComponentStep(){

            @XMLClassname(value="addlistener")
            public Object execute(IInternalAccess ia) {
                return ia.getServiceContainer().getProvidedServices(IChatService.class)[0];
            }
        }).addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IChatService cs = (IChatService)result;
                cs.addChangeListener(new IRemoteChangeListener(){

                    public IFuture changeOccurred(ChangeEvent event) {
                        Future ret = new Future();
                        if (!ChatPanel.this.isVisible()) {
                            ret.setException((Exception)new RuntimeException("Gui closed."));
                        } else {
                            ChatPanel.this.addMessage((String)event.getSource(), (String)event.getValue());
                            ret.setResult(null);
                        }
                        return ret;
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)main, "Center");
        this.add((Component)south, "South");
    }

    public static ChatPanel createGui(final IExternalAccess agent) {
        final JFrame f = new JFrame(agent.getComponentIdentifier().getName());
        ChatPanel cp = new ChatPanel(agent);
        f.add(cp);
        f.pack();
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                agent.killComponent();
            }
        });
        agent.scheduleStep(new IComponentStep(){

            @XMLClassname(value="dispose")
            public Object execute(IInternalAccess ia) {
                ia.addComponentListener((IComponentListener)new TerminationAdapter(){

                    public void componentTerminated() {
                        f.setVisible(false);
                    }
                });
                return null;
            }
        });
        return cp;
    }

    public void addMessage(String name, String text) {
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(name).append("]: ").append(text).append(lf);
        this.chatarea.append(buf.toString());
    }

    public void tell(final String name, final String text) {
        this.agent.scheduleStep(new IComponentStep(){

            public Object execute(IInternalAccess ia) {
                ia.getServiceContainer().getRequiredServices("chatservices").addResultListener((IResultListener)new IIntermediateResultListener(){

                    public void resultAvailable(Object result) {
                        if (result != null) {
                            for (IChatService cs : (Collection)result) {
                                cs.hear(name, text);
                            }
                        }
                    }

                    public void exceptionOccurred(Exception exception) {
                        exception.printStackTrace();
                    }

                    public void intermediateResultAvailable(Object result) {
                        ((IChatService)result).hear(name, text);
                    }

                    public void finished() {
                    }
                });
                return null;
            }
        });
    }
}

