/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.chat;

import jadex.bridge.IInternalAccess;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.commons.ChangeEvent;
import jadex.commons.IRemoteChangeListener;
import jadex.commons.future.IResultListener;
import jadex.micro.examples.chat.ChatPanel;
import jadex.micro.examples.chat.IChatService;
import java.util.ArrayList;
import java.util.List;

public class ChatService
implements IChatService {
    @ServiceComponent
    protected IInternalAccess agent;
    protected List listeners;
    protected ChatPanel chatpanel;

    @ServiceStart
    public void start() {
        this.listeners = new ArrayList();
        this.chatpanel = ChatPanel.createGui(this.agent.getExternalAccess());
    }

    @Override
    public void hear(String name, String text) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            final IRemoteChangeListener lis = (IRemoteChangeListener)this.listeners.get(i);
            lis.changeOccurred(new ChangeEvent((Object)name, null, (Object)text)).addResultListener(this.agent.createResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                }

                public void exceptionOccurred(Exception exception) {
                    ChatService.this.listeners.remove(lis);
                }
            }));
        }
    }

    @Override
    public void addChangeListener(IRemoteChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(IRemoteChangeListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "ChatService, " + this.agent.getComponentIdentifier();
    }
}

