/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.fireflies;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.commons.IFilter;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.ContinuousSpace2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Int;
import jadex.extension.envsupport.math.Vector2Double;
import jadex.micro.MicroAgent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class FireflyAgent
extends MicroAgent {
    public void executeBody() {
        IExternalAccess paexta = this.getParent();
        paexta.getExtension("mygc2dspace").addResultListener(this.createResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                final ContinuousSpace2D space = (ContinuousSpace2D)result;
                IComponentStep step = new IComponentStep(){

                    public Object execute(IInternalAccess ia) {
                        if (space == null) {
                            return null;
                        }
                        ISpaceObject avatar = space.getAvatar(FireflyAgent.this.getComponentDescription());
                        IVector2 mypos = (IVector2)avatar.getProperty("position");
                        double dir = ((Number)avatar.getProperty("direction")).doubleValue();
                        int clock = ((Number)avatar.getProperty("clock")).intValue();
                        int threshold = ((Number)avatar.getProperty("threshold")).intValue();
                        int window = ((Number)avatar.getProperty("window")).intValue();
                        int resetlevel = ((Number)avatar.getProperty("reset_level")).intValue();
                        int flashestoreset = ((Number)space.getProperty("flashes_to_reset")).intValue();
                        int cyclelength = ((Number)space.getProperty("cycle_length")).intValue();
                        double factor = 10.0;
                        double rotchange = Math.random() * Math.PI / factor - 1.5707963267948966 / factor;
                        double newdir = dir + rotchange;
                        if (newdir < 0.0) {
                            newdir += Math.PI * 2;
                        } else if (newdir > Math.PI * 2) {
                            newdir -= Math.PI * 2;
                        }
                        double x = Math.sin(newdir);
                        double y = -Math.cos(newdir);
                        double stepwidth = 0.1;
                        Vector2Double newdirvec = new Vector2Double(x * stepwidth, y * stepwidth);
                        IVector2 newpos = mypos.copy().add((IVector2)newdirvec);
                        if (++clock == cyclelength) {
                            clock = 0;
                        }
                        if (clock > window && clock >= threshold) {
                            Set tmp = Collections.EMPTY_SET;
                            tmp = space.getNearObjects((IVector2)avatar.getProperty("position"), (IVector1)new Vector1Int(1), "firefly", new IFilter(){

                                public boolean filter(Object obj) {
                                    ISpaceObject fly = (ISpaceObject)obj;
                                    return (Boolean)fly.getProperty("flashing");
                                }
                            });
                            tmp.remove(avatar);
                            if (tmp.size() >= flashestoreset) {
                                clock = resetlevel;
                            }
                        }
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("object_id", avatar.getId());
                        params.put("position", newpos);
                        params.put("direction", new Double(newdir));
                        params.put("clock", new Integer(clock));
                        space.performSpaceAction("move", params, null);
                        FireflyAgent.this.waitForTick(this);
                        return null;
                    }

                    public String toString() {
                        return "firebug.body()";
                    }
                };
                FireflyAgent.this.waitForTick(step);
            }
        }));
    }
}

