/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.heatbugs;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Grid2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Int;
import jadex.micro.MicroAgent;
import java.util.HashMap;
import java.util.Set;

public class HeatbugAgent
extends MicroAgent {
    protected double randomchance;
    protected double ideal_temp;
    protected double mytemp;
    protected double unhappiness;

    public void executeBody() {
        this.getParent().getExtension("mygc2dspace").addResultListener(this.createResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                if (result == null) {
                    return;
                }
                final Grid2D grid = (Grid2D)result;
                ISpaceObject avatar = grid.getAvatar(HeatbugAgent.this.getComponentDescription());
                HeatbugAgent.this.randomchance = ((Number)avatar.getProperty("random_move_chance")).doubleValue();
                HeatbugAgent.this.ideal_temp = ((Number)avatar.getProperty("ideal_temp")).doubleValue();
                IComponentStep com = new IComponentStep(){

                    public Object execute(IInternalAccess ia) {
                        ISpaceObject avatar = grid.getAvatar(HeatbugAgent.this.getComponentDescription());
                        IVector2 mypos = (IVector2)avatar.getProperty("position");
                        ISpaceObject patch = (ISpaceObject)grid.getSpaceObjectsByGridPosition(mypos, (Object)"patch").iterator().next();
                        HeatbugAgent.this.mytemp = ((Number)patch.getProperty("heat")).doubleValue();
                        HeatbugAgent.this.unhappiness = ((Number)avatar.getProperty("unhappiness")).doubleValue();
                        if (HeatbugAgent.this.unhappiness > 0.0) {
                            Set tmp = grid.getNearObjects((IVector2)avatar.getProperty("position"), (IVector1)new Vector1Int(1), "patch");
                            tmp.remove(patch);
                            ISpaceObject[] neighbors = tmp.toArray(new ISpaceObject[tmp.size()]);
                            IVector2 target = null;
                            if (Math.random() < HeatbugAgent.this.randomchance) {
                                IVector2 choicepos;
                                int choice = (int)(Math.random() * (double)neighbors.length);
                                target = choicepos = (IVector2)neighbors[choice].getProperty("position");
                            } else if (HeatbugAgent.this.mytemp > HeatbugAgent.this.ideal_temp) {
                                ISpaceObject min = patch;
                                double minheat = HeatbugAgent.this.mytemp;
                                for (int i = 0; i < neighbors.length; ++i) {
                                    double heat = ((Number)neighbors[i].getProperty("heat")).doubleValue();
                                    if (!(heat < minheat)) continue;
                                    min = neighbors[i];
                                    minheat = heat;
                                }
                                target = (IVector2)min.getProperty("position");
                            } else {
                                ISpaceObject max = patch;
                                double maxheat = HeatbugAgent.this.mytemp;
                                for (int i = 0; i < neighbors.length; ++i) {
                                    double heat = ((Number)neighbors[i].getProperty("heat")).doubleValue();
                                    if (!(heat > maxheat)) continue;
                                    max = neighbors[i];
                                    maxheat = heat;
                                }
                                target = (IVector2)max.getProperty("position");
                            }
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("object_id", avatar.getId());
                            params.put("position", target);
                            grid.performSpaceAction("move", params, null);
                        }
                        HeatbugAgent.this.waitForTick(this);
                        return null;
                    }

                    public String toString() {
                        return "heatbug.body()";
                    }
                };
                HeatbugAgent.this.waitForTick(com);
            }
        }));
    }
}

