/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.helpline;

import jadex.bridge.service.annotation.GuiClass;
import jadex.bridge.service.clock.IClockService;
import jadex.commons.SReflect;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.IMicroExternalAccess;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.helpline.HelplinePanel;
import jadex.micro.examples.helpline.HelplineService;
import jadex.micro.examples.helpline.HelplineViewerPanel;
import jadex.micro.examples.helpline.IHelpline;
import jadex.micro.examples.helpline.InformationEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.SwingUtilities;

@Description(value="This agent offers a helpline for getting information about missing persons.")
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="platform")), @RequiredService(name="remotehelplineservices", type=IHelpline.class, multiple=true, binding=@Binding(scope="global")), @RequiredService(name="localhelplineservices", type=IHelpline.class, multiple=true, binding=@Binding(scope="platform"))})
@ProvidedServices(value={@ProvidedService(type=IHelpline.class, implementation=@Implementation(value=HelplineService.class))})
@GuiClass(value=HelplineViewerPanel.class)
public class HelplineAgent
extends MicroAgent {
    protected MultiCollection infos;

    public IFuture agentCreated() {
        this.infos = new MultiCollection();
        Object ini = this.getArgument("infos");
        if (ini != null && SReflect.isIterable((Object)ini)) {
            Iterator it = SReflect.getIterator((Object)ini);
            while (it.hasNext()) {
                InformationEntry ie = (InformationEntry)it.next();
                this.infos.put((Object)ie.getName(), (Object)ie);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelplinePanel.createHelplineGui((IMicroExternalAccess)HelplineAgent.this.getExternalAccess());
            }
        });
        return IFuture.DONE;
    }

    public void addInformation(final String name, final String info) {
        this.getRequiredService("clockservice").addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                IClockService cs = (IClockService)result;
                HelplineAgent.this.infos.put((Object)name, (Object)new InformationEntry(name, info, cs.getTime()));
            }
        });
    }

    public Collection getInformation(String name) {
        Collection ret = (Collection)this.infos.get((Object)name);
        return ret != null ? ret : Collections.EMPTY_LIST;
    }
}

