/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.hunterprey;

import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.service.IServiceProvider;
import jadex.bridge.service.SServiceProvider;
import jadex.commons.SimplePropertyObject;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceAction;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Grid2D;
import java.util.Map;

public class EatAction
extends SimplePropertyObject
implements ISpaceAction {
    public static final String PROPERTY_POINTS = "points";

    public Object perform(Map parameters, IEnvironmentSpace space) {
        Grid2D grid = (Grid2D)space;
        IComponentDescription owner = (IComponentDescription)parameters.get("actor_id");
        ISpaceObject avatar = grid.getAvatar(owner);
        final ISpaceObject target = (ISpaceObject)parameters.get("object_id");
        if (null == space.getSpaceObject(target.getId())) {
            throw new RuntimeException("No such object in space: " + target);
        }
        if (!avatar.getProperty("position").equals(target.getProperty("position"))) {
            throw new RuntimeException("Can only eat objects at same position.");
        }
        Integer points = (Integer)avatar.getProperty(PROPERTY_POINTS);
        if (avatar.getType().equals("prey") && target.getType().equals("food")) {
            points = points != null ? new Integer(points + 1) : new Integer(1);
        } else if (avatar.getType().equals("hunter") && target.getType().equals("prey")) {
            points = points != null ? new Integer(points + 5) : new Integer(5);
        } else {
            throw new RuntimeException("Objects of type '" + avatar.getType() + "' cannot eat objects of type '" + target.getType() + "'.");
        }
        space.destroySpaceObject(target.getId());
        if (target.getProperty("owner") != null) {
            SServiceProvider.getServiceUpwards((IServiceProvider)space.getExternalAccess().getServiceProvider(), IComponentManagementService.class).addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    IComponentManagementService cms = (IComponentManagementService)result;
                    cms.destroyComponent(((IComponentDescription)target.getProperty("owner")).getName());
                }

                public void exceptionOccurred(Exception exception) {
                }
            });
        }
        avatar.setProperty(PROPERTY_POINTS, (Object)points);
        return null;
    }
}

