/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.hunterprey;

import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Grid2D;
import jadex.extension.envsupport.math.IVector2;
import jadex.micro.MicroAgent;
import jadex.micro.examples.hunterprey.MoveAction;
import jadex.xml.annotation.XMLClassname;
import java.util.HashMap;

public class MicroPreyAgent
extends MicroAgent {
    protected Grid2D env;
    protected ISpaceObject myself;
    protected String lastdir;
    protected ISpaceObject food;
    protected IResultListener listener;

    public void executeBody() {
        this.getParent().getExtension("my2dspace").addResultListener(this.createResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object result) {
                if (result == null) {
                    return;
                }
                MicroPreyAgent.this.env = (Grid2D)result;
                MicroPreyAgent.this.myself = MicroPreyAgent.this.env.getAvatar(MicroPreyAgent.this.getComponentDescription());
                MicroPreyAgent.this.listener = new IResultListener(){

                    public void exceptionOccurred(Exception e) {
                        try {
                            MicroPreyAgent.this.getExternalAccess().scheduleStep(new IComponentStep(){

                                @XMLClassname(value="act")
                                public Object execute(IInternalAccess agent) {
                                    MicroPreyAgent.this.food = null;
                                    MicroPreyAgent.this.lastdir = "left".equals(MicroPreyAgent.this.lastdir) || "right".equals(MicroPreyAgent.this.lastdir) ? (Math.random() > 0.5 ? "up" : "down") : (Math.random() > 0.5 ? "left" : "right");
                                    MicroPreyAgent.this.act();
                                    return null;
                                }

                                public String toString() {
                                    return "prey.act()";
                                }
                            });
                        }
                        catch (ComponentTerminatedException componentTerminatedException) {
                            // empty catch block
                        }
                    }

                    public void resultAvailable(Object result) {
                        MicroPreyAgent.this.getExternalAccess().scheduleStep(new IComponentStep(){

                            @XMLClassname(value="act2")
                            public Object execute(IInternalAccess ia) {
                                MicroPreyAgent.this.act();
                                return null;
                            }

                            public String toString() {
                                return "prey.act()";
                            }
                        });
                    }
                };
                MicroPreyAgent.this.act();
            }
        }));
    }

    protected void act() {
        IVector2 pos = (IVector2)this.myself.getProperty("position");
        if (this.food != null && pos.equals(this.food.getProperty("position"))) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("actor_id", this.getComponentDescription());
            params.put("object_id", this.food);
            this.env.performSpaceAction("eat", params, this.listener);
        } else {
            if (this.food != null) {
                String newdir = MoveAction.getDirection(this.env, pos, (IVector2)this.food.getProperty("position"));
                if (!"none".equals(newdir)) {
                    this.lastdir = newdir;
                } else {
                    this.food = null;
                }
            } else if (this.lastdir == null || Math.random() > 0.75) {
                this.lastdir = "left".equals(this.lastdir) || "right".equals(this.lastdir) ? (Math.random() > 0.5 ? "up" : "down") : (Math.random() > 0.5 ? "left" : "right");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("actor_id", this.getComponentDescription());
            params.put("direction", this.lastdir);
            this.env.performSpaceAction("move", params, this.listener);
        }
    }

    public ISpaceObject getNearestFood() {
        return this.food;
    }

    public void setNearestFood(ISpaceObject food) {
        this.food = food;
    }
}

