/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.hunterprey;

import jadex.bridge.IComponentDescription;
import jadex.commons.SimplePropertyObject;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceAction;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Grid2D;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector2Int;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MoveAction
extends SimplePropertyObject
implements ISpaceAction {
    public static final String PARAMETER_DIRECTION = "direction";
    public static final String PROPERTY_LASTPOS = "lastpos";
    public static final String DIRECTION_LEFT = "left";
    public static final String DIRECTION_RIGHT = "right";
    public static final String DIRECTION_UP = "up";
    public static final String DIRECTION_DOWN = "down";
    public static final String DIRECTION_NONE = "none";

    public Object perform(Map parameters, IEnvironmentSpace space) {
        Grid2D grid = (Grid2D)space;
        IComponentDescription actor = (IComponentDescription)parameters.get("actor_id");
        String direction = (String)parameters.get(PARAMETER_DIRECTION);
        ISpaceObject avatar = grid.getAvatar(actor);
        if (null == space.getSpaceObject(avatar.getId())) {
            throw new RuntimeException("No such object in space: " + avatar);
        }
        IVector2 pos = (IVector2)avatar.getProperty("position");
        boolean skip = false;
        if (DIRECTION_LEFT.equals(direction)) {
            pos = new Vector2Int(pos.getXAsInteger() - 1, pos.getYAsInteger());
        } else if (DIRECTION_RIGHT.equals(direction)) {
            pos = new Vector2Int(pos.getXAsInteger() + 1, pos.getYAsInteger());
        } else if (DIRECTION_UP.equals(direction)) {
            pos = new Vector2Int(pos.getXAsInteger(), pos.getYAsInteger() - 1);
        } else if (DIRECTION_DOWN.equals(direction)) {
            pos = new Vector2Int(pos.getXAsInteger(), pos.getYAsInteger() + 1);
        } else if (DIRECTION_NONE.equals(direction)) {
            skip = true;
        } else {
            throw new RuntimeException("Unknown move direction: " + direction);
        }
        if (!skip) {
            Collection obstacles = grid.getSpaceObjectsByGridPosition(pos, (Object)"obstacle");
            if (obstacles != null && !obstacles.isEmpty()) {
                throw new RuntimeException("Cannot move '" + direction + "' due to obstacles: " + obstacles);
            }
            if (avatar.getType().equals("prey")) {
                Collection hunters = grid.getSpaceObjectsByGridPosition((IVector2)avatar.getProperty("position"), (Object)"hunter");
                if (hunters != null) {
                    pos = grid.adjustPosition(pos);
                    for (ISpaceObject hunter : hunters) {
                        if (!pos.equals(hunter.getProperty(PROPERTY_LASTPOS))) continue;
                        throw new RuntimeException("Cannot move '" + direction + "' due to hunter: " + hunter);
                    }
                }
            } else if (avatar.getType().equals("hunter")) {
                avatar.setProperty(PROPERTY_LASTPOS, avatar.getProperty("position"));
            }
            grid.setPosition(avatar.getId(), pos);
        }
        return null;
    }

    public static String getDirection(final Grid2D space, IVector2 sourcepos, final IVector2 targetpos) {
        String ret = MoveAction.evaluateMoves(space, sourcepos, new IMoveEvaluator(){

            @Override
            public double evaluateMove(IVector2 position) {
                return -space.getDistance(position, targetpos).getAsDouble();
            }
        });
        return ret;
    }

    public static String getAvoidanceDirection(final Grid2D space, IVector2 sourcepos, final ISpaceObject[] objects) {
        String ret = MoveAction.evaluateMoves(space, sourcepos, new IMoveEvaluator(){

            @Override
            public double evaluateMove(IVector2 position) {
                double mindist = Double.POSITIVE_INFINITY;
                for (int i = 0; i < objects.length; ++i) {
                    mindist = Math.min(mindist, space.getDistance(position, (IVector2)objects[i].getProperty("position")).getAsDouble());
                }
                return mindist;
            }
        });
        return ret;
    }

    public static String evaluateMoves(Grid2D space, IVector2 sourcepos, IMoveEvaluator eval) {
        IVector2 pos;
        String ret = null;
        HashMap<String, Vector2Int> moves = new HashMap<String, Vector2Int>();
        moves.put(DIRECTION_NONE, new Vector2Int(sourcepos.getXAsInteger(), sourcepos.getYAsInteger()));
        moves.put(DIRECTION_LEFT, new Vector2Int(sourcepos.getXAsInteger() - 1, sourcepos.getYAsInteger()));
        moves.put(DIRECTION_RIGHT, new Vector2Int(sourcepos.getXAsInteger() + 1, sourcepos.getYAsInteger()));
        moves.put(DIRECTION_UP, new Vector2Int(sourcepos.getXAsInteger(), sourcepos.getYAsInteger() - 1));
        moves.put(DIRECTION_DOWN, new Vector2Int(sourcepos.getXAsInteger(), sourcepos.getYAsInteger() + 1));
        double maxval = Double.NEGATIVE_INFINITY;
        Iterator it = moves.keySet().iterator();
        while (it.hasNext()) {
            pos = (IVector2)moves.get(it.next());
            Collection obstacles = space.getSpaceObjectsByGridPosition(pos, (Object)"obstacle");
            if (obstacles != null && !obstacles.isEmpty()) {
                it.remove();
                continue;
            }
            maxval = Math.max(maxval, eval.evaluateMove(pos));
        }
        it = moves.keySet().iterator();
        while (it.hasNext()) {
            pos = (IVector2)moves.get(it.next());
            if (!(eval.evaluateMove(pos) < maxval)) continue;
            it.remove();
        }
        if (moves.size() > 0) {
            int chosen = (int)(Math.random() * (double)moves.size());
            Iterator it2 = moves.keySet().iterator();
            for (int i = 0; i <= chosen; ++i) {
                ret = (String)it2.next();
            }
        }
        return ret;
    }

    public static String[] getPossibleDirections(Grid2D space, IVector2 sourcepos) {
        String[] stringArray;
        HashMap<String, Vector2Int> moves = new HashMap<String, Vector2Int>();
        moves.put(DIRECTION_LEFT, new Vector2Int(sourcepos.getXAsInteger() - 1, sourcepos.getYAsInteger()));
        moves.put(DIRECTION_RIGHT, new Vector2Int(sourcepos.getXAsInteger() + 1, sourcepos.getYAsInteger()));
        moves.put(DIRECTION_UP, new Vector2Int(sourcepos.getXAsInteger(), sourcepos.getYAsInteger() - 1));
        moves.put(DIRECTION_DOWN, new Vector2Int(sourcepos.getXAsInteger(), sourcepos.getYAsInteger() + 1));
        Iterator it = moves.keySet().iterator();
        while (it.hasNext()) {
            IVector2 pos = (IVector2)moves.get(it.next());
            Collection obstacles = space.getSpaceObjectsByGridPosition(pos, (Object)"obstacle");
            if (obstacles == null || obstacles.isEmpty()) continue;
            it.remove();
        }
        if (moves.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = DIRECTION_NONE;
        } else {
            stringArray = moves.keySet().toArray(new String[moves.size()]);
        }
        return stringArray;
    }

    public static interface IMoveEvaluator {
        public double evaluateMove(IVector2 var1);
    }
}

