/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.IComponentIdentifier;
import jadex.commons.Base64;
import jadex.micro.examples.mandelbrot.ArrayTest;
import jadex.micro.examples.mandelbrot.IFractalAlgorithm;

public class AreaData {
    protected double xstart;
    protected double xend;
    protected double ystart;
    protected double yend;
    protected int xoff;
    protected int yoff;
    protected int sizex;
    protected int sizey;
    protected short max;
    protected int par;
    protected IComponentIdentifier cid;
    protected int tasksize;
    protected IFractalAlgorithm algorithm;
    protected short[][] data;

    public AreaData() {
    }

    public AreaData(double xstart, double xend, double ystart, double yend, int sizex, int sizey, short max, int par, int tasksize, IFractalAlgorithm algorithm) {
        this(xstart, xend, ystart, yend, 0, 0, sizex, sizey, max, par, tasksize, algorithm, null, null);
    }

    public AreaData(double xstart, double xend, double ystart, double yend, int xoff, int yoff, int sizex, int sizey, short max, int par, int tasksize, IFractalAlgorithm algorithm, IComponentIdentifier cid, short[][] data) {
        this.xstart = xstart;
        this.xend = xend;
        this.ystart = ystart;
        this.yend = yend;
        this.xoff = xoff;
        this.yoff = yoff;
        this.sizex = sizex;
        this.sizey = sizey;
        this.max = max;
        this.par = par;
        this.tasksize = tasksize;
        this.algorithm = algorithm;
        this.cid = cid;
        this.data = data;
    }

    public double getXStart() {
        return this.xstart;
    }

    public void setXStart(double xstart) {
        this.xstart = xstart;
    }

    public double getXEnd() {
        return this.xend;
    }

    public void setXEnd(double xend) {
        this.xend = xend;
    }

    public double getYStart() {
        return this.ystart;
    }

    public void setYStart(double ystart) {
        this.ystart = ystart;
    }

    public double getYEnd() {
        return this.yend;
    }

    public void setYEnd(double yend) {
        this.yend = yend;
    }

    public int getXOffset() {
        return this.xoff;
    }

    public void setXOffset(int xoff) {
        this.xoff = xoff;
    }

    public int getYOffset() {
        return this.yoff;
    }

    public void setYOffset(int yoff) {
        this.yoff = yoff;
    }

    public int getSizeX() {
        return this.sizex;
    }

    public void setSizeX(int sizex) {
        this.sizex = sizex;
    }

    public int getSizeY() {
        return this.sizey;
    }

    public void setSizeY(int sizey) {
        this.sizey = sizey;
    }

    public short getMax() {
        return this.max;
    }

    public void setMax(short max) {
        this.max = max;
    }

    public short[][] fetchData() {
        return this.data;
    }

    public void setData(short[][] data) {
        this.data = data;
    }

    public String getDataString() {
        String ret = null;
        if (this.data != null) {
            ret = new String(Base64.encode((byte[])ArrayTest.shortToByte(this.data)));
        }
        return ret;
    }

    public void setDataString(String sdata) {
        this.data = ArrayTest.byteToshort(Base64.decode((byte[])sdata.getBytes()));
    }

    public int getParallel() {
        return this.par;
    }

    public void setParallel(int par) {
        this.par = par;
    }

    public IComponentIdentifier getCalculatorId() {
        return this.cid;
    }

    public void setCalculatorId(IComponentIdentifier cid) {
        this.cid = cid;
    }

    public int getTaskSize() {
        return this.tasksize;
    }

    public void setTaskSize(int tasksize) {
        this.tasksize = tasksize;
    }

    public IFractalAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(IFractalAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        return "AreaData(x=" + this.xoff + ", y=" + this.yoff + ")";
    }

    public Object getId() {
        return this.toString();
    }
}

