/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.commons.Base64;
import jadex.xml.bean.JavaReader;
import jadex.xml.bean.JavaWriter;
import java.util.Random;
import java.util.StringTokenizer;

public class ArrayTest {
    public static String shortToString(short[][] data) {
        String ret = null;
        if (data != null) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(data.length);
            sbuf.append(" ");
            sbuf.append(data[0].length);
            sbuf.append("\n");
            for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
                if (i > 0) {
                    sbuf.append("\n");
                }
                for (int j = 0; j < data[i].length; j = (int)((short)(j + 1))) {
                    if (j > 0) {
                        sbuf.append(" ");
                    }
                    sbuf.append(data[i][j]);
                }
            }
            ret = sbuf.toString();
        }
        return ret;
    }

    public static short[][] stringToshort(String sdata) {
        StringTokenizer stok = new StringTokenizer(sdata);
        short rows = Short.parseShort(stok.nextToken());
        short cols = Short.parseShort(stok.nextToken());
        short[][] data = new short[rows][cols];
        for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
            for (int j = 0; j < data[i].length; j = (int)((short)(j + 1))) {
                data[i][j] = Short.parseShort(stok.nextToken());
            }
        }
        return data;
    }

    public static byte[] shortToByte(short[][] data) {
        byte[] ret = null;
        if (data != null) {
            short rows = (short)data.length;
            short cols = (short)data[0].length;
            ret = new byte[rows * cols * 2 + 4];
            int offset = 0;
            ArrayTest.shortToBytes(rows, ret, offset);
            ArrayTest.shortToBytes(cols, ret, offset += 2);
            for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
                for (int j = 0; j < data[i].length; j = (int)((short)(j + 1))) {
                    ArrayTest.shortToBytes(data[i][j], ret, offset += 2);
                }
            }
        }
        return ret;
    }

    public static short[][] byteToshort(byte[] sdata) {
        int offset = 0;
        short rows = ArrayTest.bytesToshort(sdata, offset);
        short cols = ArrayTest.bytesToshort(sdata, offset += 2);
        short[][] data = new short[rows][cols];
        for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
            for (int j = 0; j < data[i].length; j = (int)((short)(j + 1))) {
                data[i][j] = ArrayTest.bytesToshort(sdata, offset += 2);
            }
        }
        return data;
    }

    protected static short bytesToshort(byte[] buffer, int offset) {
        short value = (short)((0xFF & buffer[offset + 0]) << 8);
        value = (short)(value | 0xFF & buffer[offset + 1]);
        return value;
    }

    protected static byte[] shortToBytes(short val, byte[] buffer, int offset) {
        buffer[offset + 0] = (byte)(val >>> 8);
        buffer[offset + 1] = (byte)val;
        return buffer;
    }

    public static void main(String[] args) {
        int j;
        int i;
        short[][] data = new short[1234][1357];
        System.out.println("filling array...");
        Random r = new Random();
        for (int i2 = 0; i2 < data.length; i2 = (int)((short)(i2 + 1))) {
            for (int j2 = 0; j2 < data[i2].length; j2 = (int)((short)(j2 + 1))) {
                data[i2][j2] = (short)(r.nextInt(2000) - 1);
            }
        }
        System.out.println("encoding array...");
        long start = System.nanoTime();
        String str = ArrayTest.shortToString(data);
        long time = System.nanoTime() - start;
        System.out.println("encoding array took " + time / 1000000L + " milliseconds");
        System.out.println("encoded array is " + str.length() + " bytes");
        System.out.println("decoding array...");
        start = System.nanoTime();
        short[][] data2 = ArrayTest.stringToshort(str);
        time = System.nanoTime() - start;
        System.out.println("decoding array took " + time / 1000000L + " milliseconds");
        System.out.println("Comparing arrays...");
        boolean equal = data.length == data2.length;
        for (int i3 = 0; equal && i3 < data.length; i3 = (int)((short)(i3 + 1))) {
            equal = data[i3].length == data2[i3].length;
            for (int j3 = 0; j3 < data[i3].length; j3 = (int)((short)(j3 + 1))) {
                equal = data[i3][j3] == data2[i3][j3];
            }
        }
        System.out.println("Arrays are " + (equal ? "equal" : "different!") + "\n");
        System.out.println("encoding array to bytes...");
        start = System.nanoTime();
        byte[] bytes = ArrayTest.shortToByte(data);
        time = System.nanoTime() - start;
        System.out.println("encoding to bytes took " + time / 1000000L + " milliseconds");
        System.out.println("encoded array is " + bytes.length + " bytes");
        System.out.println("decoding bytes...");
        start = System.nanoTime();
        data2 = ArrayTest.byteToshort(bytes);
        time = System.nanoTime() - start;
        System.out.println("decoding bytes took " + time / 1000000L + " milliseconds");
        System.out.println("Comparing arrays...");
        equal = data.length == data2.length;
        for (i = 0; equal && i < data.length; i = (int)((short)(i + 1))) {
            equal = data[i].length == data2[i].length;
            for (j = 0; j < data[i].length; j = (int)((short)(j + 1))) {
                equal = data[i][j] == data2[i][j];
            }
        }
        System.out.println("Arrays are " + (equal ? "equal" : "different!") + "\n");
        System.out.println("encoding array to base64...");
        start = System.nanoTime();
        str = new String(Base64.encode((byte[])ArrayTest.shortToByte(data)));
        time = System.nanoTime() - start;
        System.out.println("encoding to base64 took " + time / 1000000L + " milliseconds");
        System.out.println("encoded array is " + str.length() + " bytes");
        System.out.println("decoding base64...");
        start = System.nanoTime();
        data2 = ArrayTest.byteToshort(Base64.decode((byte[])str.getBytes()));
        time = System.nanoTime() - start;
        System.out.println("decoding base64 took " + time / 1000000L + " milliseconds");
        System.out.println("Comparing arrays...");
        equal = data.length == data2.length;
        for (i = 0; equal && i < data.length; i = (int)((short)(i + 1))) {
            equal = data[i].length == data2[i].length;
            for (j = 0; j < data[i].length; j = (int)((short)(j + 1))) {
                equal = data[i][j] == data2[i][j];
            }
        }
        System.out.println("Arrays are " + (equal ? "equal" : "different!") + "\n");
        System.out.println("encoding array to XML...");
        start = System.nanoTime();
        str = JavaWriter.objectToXML((Object)data, (ClassLoader)ArrayTest.class.getClassLoader());
        time = System.nanoTime() - start;
        System.out.println("encoding to XML took " + time / 1000000L + " milliseconds");
        System.out.println("encoded array is " + str.length() + " bytes");
        System.out.println("decoding XML...");
        start = System.nanoTime();
        data2 = (short[][])JavaReader.objectFromXML((String)str, (ClassLoader)ArrayTest.class.getClassLoader());
        time = System.nanoTime() - start;
        System.out.println("decoding XML took " + time / 1000000L + " milliseconds");
        System.out.println("Comparing arrays...");
        equal = data.length == data2.length;
        for (i = 0; equal && i < data.length; i = (int)((short)(i + 1))) {
            equal = data[i].length == data2[i].length;
            for (j = 0; j < data[i].length; j = (int)((short)(j + 1))) {
                equal = data[i][j] == data2[i][j];
            }
        }
        System.out.println("Arrays are " + (equal ? "equal" : "different!") + "\n");
    }
}

