/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.NameValue;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.examples.mandelbrot.CalculateService;
import jadex.micro.examples.mandelbrot.ICalculateService;
import jadex.micro.examples.mandelbrot.IProgressService;
import jadex.micro.examples.mandelbrot.ProgressService;

@Description(value="Agent offering a calculate service.")
@ProvidedServices(value={@ProvidedService(type=ICalculateService.class, implementation=@Implementation(value=CalculateService.class)), @ProvidedService(type=IProgressService.class, implementation=@Implementation(value=ProgressService.class, proxytype="direct"))})
@Arguments(value={@Argument(name="delay", description="Agent kills itself when no job arrives in the delay interval.", clazz=Long.class, defaultvalue="new Long(1000)")})
@Configurations(value={@Configuration(name="default"), @Configuration(name="long lived", arguments={@NameValue(name="delay", value="-1")})})
public class CalculateAgent
extends MicroAgent {
    protected boolean hadjob;
    protected Object taskid;
    protected int progress;

    public void executeBody() {
        final long delay = ((Number)this.getArgument("delay")).longValue();
        IComponentStep step = new IComponentStep(){

            public Object execute(IInternalAccess ia) {
                if (!CalculateAgent.this.isHadJob()) {
                    CalculateAgent.this.killComponent();
                }
                CalculateAgent.this.setHadJob(false);
                CalculateAgent.this.waitFor(delay, this);
                return null;
            }
        };
        if (delay > 0L) {
            this.waitFor(delay, step);
        }
    }

    public void setHadJob(boolean hadjob) {
        this.hadjob = hadjob;
    }

    public boolean isHadJob() {
        return this.hadjob;
    }

    public Object getTaskId() {
        return this.taskid;
    }

    public void setTaskId(Object taskid) {
        this.taskid = taskid;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }
}

