/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.micro.examples.mandelbrot.DisplayPanel;
import jadex.micro.examples.mandelbrot.GenerateService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ColorChooserPanel
extends JPanel {
    public ColorChooserPanel(final DisplayPanel panel) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Color Scheme"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        final JCheckBox cycle = new JCheckBox("Cycle", GenerateService.ALGORITHMS[0].useColorCycle());
        final DefaultListModel<Color> lm = new DefaultListModel<Color>();
        lm.addElement(new Color(204, 204, 255));
        lm.addElement(new Color(0, 0, 255));
        lm.addElement(new Color(0, 0, 51));
        lm.addElement(new Color(0, 0, 255));
        this.setColorScheme(panel, lm, cycle.isSelected());
        final JList colors = new JList(lm);
        this.add((Component)new JScrollPane(colors), gbc);
        colors.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, final Object value, int index, final boolean selected, boolean focus) {
                return new JComponent(){

                    @Override
                    protected void paintComponent(Graphics g) {
                        Rectangle bounds = this.getBounds();
                        Insets insets = this.getInsets();
                        if (insets != null) {
                            bounds.x = insets.left;
                            bounds.y = insets.top;
                            bounds.width -= insets.left + insets.right;
                            bounds.height -= insets.top + insets.bottom;
                        } else {
                            bounds.x = 0;
                            bounds.y = 0;
                        }
                        g.setColor(selected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("List.background"));
                        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                        g.setColor(selected ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("List.foreground"));
                        g.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3);
                        g.setColor((Color)value);
                        g.fillRect(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(16, 16);
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return new Dimension(8, 8);
                    }
                };
            }
        });
        JButton add = new JButton("add"){

            @Override
            public Insets getInsets() {
                return new Insets(0, 3, 0, 3);
            }
        };
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(ColorChooserPanel.this, "Choose a color to add", Color.yellow);
                if (c != null) {
                    lm.addElement(c);
                    ColorChooserPanel.this.setColorScheme(panel, lm, cycle.isSelected());
                }
            }
        });
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)add, gbc);
        JButton remove = new JButton("rem"){

            @Override
            public Insets getInsets() {
                return new Insets(0, 3, 0, 3);
            }
        };
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] cs = colors.getSelectedValues();
                for (int i = 0; i < cs.length; ++i) {
                    lm.removeElement(cs[i]);
                }
                ColorChooserPanel.this.setColorScheme(panel, lm, cycle.isSelected());
            }
        });
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        this.add((Component)remove, gbc);
        cycle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorChooserPanel.this.setColorScheme(panel, lm, cycle.isSelected());
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        this.add((Component)cycle, gbc);
        add.setMinimumSize(remove.getMinimumSize());
        add.setPreferredSize(remove.getPreferredSize());
    }

    protected void setColorScheme(DisplayPanel panel, DefaultListModel lm, boolean cycle) {
        Object[] scheme = new Color[lm.getSize()];
        lm.copyInto(scheme);
        panel.setColorScheme((Color[])scheme, cycle);
    }
}

