/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.IComponentListener;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.TerminationAdapter;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.gui.SGUI;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.mandelbrot.ColorChooserPanel;
import jadex.micro.examples.mandelbrot.DisplayPanel;
import jadex.micro.examples.mandelbrot.DisplayService;
import jadex.micro.examples.mandelbrot.IDisplayService;
import jadex.micro.examples.mandelbrot.IGenerateService;
import jadex.micro.examples.mandelbrot.IProgressService;
import jadex.xml.annotation.XMLClassname;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

@Description(value="Agent offering a display service.")
@ProvidedServices(value={@ProvidedService(type=IDisplayService.class, implementation=@Implementation(value=DisplayService.class))})
@RequiredServices(value={@RequiredService(name="generateservice", type=IGenerateService.class), @RequiredService(name="progressservice", type=IProgressService.class), @RequiredService(name="cmsservice", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
public class DisplayAgent
extends MicroAgent {
    protected DisplayPanel panel;

    public IFuture agentCreated() {
        final Future ret = new Future();
        this.panel = new DisplayPanel(this.getExternalAccess());
        final IExternalAccess access = this.getExternalAccess();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame frame = new JFrame(DisplayAgent.this.getAgentName());
                JScrollPane scroll = new JScrollPane(DisplayAgent.this.panel);
                JTextPane helptext = new JTextPane();
                helptext.setText("Use mouse to navigate:\n[wheel] zoom in/out\n[left button] choose and click into area\n[rigth button] drag to move, click for original area.\n");
                helptext.setEditable(false);
                JPanel right = new JPanel(new BorderLayout());
                right.add((Component)new ColorChooserPanel(DisplayAgent.this.panel), "Center");
                right.add((Component)helptext, "North");
                JSplitPane split = new JSplitPane(1, scroll, right);
                split.setResizeWeight(1.0);
                split.setOneTouchExpandable(true);
                split.setDividerLocation(375);
                frame.getContentPane().add("Center", split);
                frame.setSize(500, 400);
                frame.setLocation(SGUI.calculateMiddlePosition((Window)frame));
                frame.setVisible(true);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        access.killComponent();
                    }
                });
                access.scheduleStep(new IComponentStep(){

                    @XMLClassname(value="dispose")
                    public Object execute(IInternalAccess ia) {
                        ia.addComponentListener((IComponentListener)new TerminationAdapter(){

                            public void componentTerminated() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        frame.dispose();
                                    }
                                });
                            }
                        });
                        return null;
                    }
                });
                ret.setResult(null);
            }
        });
        return ret;
    }

    public DisplayPanel getPanel() {
        return this.panel;
    }
}

