/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.base.gui.SwingDefaultResultListener;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.IServiceProvider;
import jadex.bridge.service.SServiceProvider;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.examples.mandelbrot.AreaData;
import jadex.micro.examples.mandelbrot.GenerateService;
import jadex.micro.examples.mandelbrot.IGenerateService;
import jadex.micro.examples.mandelbrot.IProgressService;
import jadex.micro.examples.mandelbrot.ProgressData;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DisplayPanel
extends JComponent {
    public static final String HELPTEXT = "Use mouse to navigate:\n[wheel] zoom in/out\n[left button] choose and click into area\n[rigth button] drag to move, click for original area.\n";
    protected IExternalAccess agent;
    protected Color[] colors;
    protected AreaData data;
    protected Image image;
    protected Point point;
    protected Rectangle range;
    protected boolean calculating;
    protected Map progressdata;
    protected Timer progressupdate;
    protected Point startdrag;
    protected Point enddrag;

    public DisplayPanel(IExternalAccess agent) {
        this.agent = agent;
        this.setColorScheme(new Color[]{new Color(50, 100, 0), Color.red}, true);
        this.calcDefaultImage();
        MouseAdapter draghandler = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!DisplayPanel.this.calculating && e.getButton() == 3 && e.getClickCount() == 1 && DisplayPanel.this.image != null) {
                    DisplayPanel.this.startdrag = new Point(e.getX(), e.getY());
                    DisplayPanel.this.range = null;
                    DisplayPanel.this.point = null;
                } else {
                    DisplayPanel.this.startdrag = null;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (DisplayPanel.this.startdrag != null) {
                    DisplayPanel.this.enddrag = new Point(e.getX(), e.getY());
                    DisplayPanel.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DisplayPanel.this.startdrag != null && DisplayPanel.this.enddrag != null) {
                    DisplayPanel.this.dragImage();
                }
            }
        };
        this.addMouseMotionListener(draghandler);
        this.addMouseListener(draghandler);
        this.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!DisplayPanel.this.calculating) {
                    int sa = e.getScrollAmount();
                    double dir = Math.signum(e.getWheelRotation());
                    double percent = 10 * sa;
                    double factor = dir > 0.0 ? (100.0 + percent) / 100.0 : 100.0 / (100.0 + percent);
                    DisplayPanel.this.zoomImage(e.getX(), e.getY(), factor);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    DisplayPanel.this.calcDefaultImage();
                } else if (!DisplayPanel.this.calculating && DisplayPanel.this.range != null && e.getX() >= DisplayPanel.this.range.x && e.getX() <= DisplayPanel.this.range.x + DisplayPanel.this.range.width && e.getY() >= DisplayPanel.this.range.y && e.getY() <= DisplayPanel.this.range.y + DisplayPanel.this.range.height) {
                    DisplayPanel.this.zoomIntoRange();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!DisplayPanel.this.calculating) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        DisplayPanel.this.point = e.getPoint();
                        DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(1));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!DisplayPanel.this.calculating) {
                    DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!DisplayPanel.this.calculating && DisplayPanel.this.range != null) {
                    if (e.getX() >= DisplayPanel.this.range.x && e.getX() <= DisplayPanel.this.range.x + DisplayPanel.this.range.width && e.getY() >= DisplayPanel.this.range.y && e.getY() <= DisplayPanel.this.range.y + DisplayPanel.this.range.height) {
                        DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!DisplayPanel.this.calculating && DisplayPanel.this.point != null) {
                    DisplayPanel.this.range = new Rectangle(DisplayPanel.this.point.x < e.getX() ? DisplayPanel.this.point.x : e.getX(), DisplayPanel.this.point.y < e.getY() ? DisplayPanel.this.point.y : e.getY(), Math.abs(DisplayPanel.this.point.x - e.getX()), Math.abs(DisplayPanel.this.point.y - e.getY()));
                    DisplayPanel.this.repaint();
                }
            }
        });
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DisplayPanel.this.range = null;
                    DisplayPanel.this.point = null;
                    DisplayPanel.this.startdrag = null;
                    DisplayPanel.this.enddrag = null;
                    DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    DisplayPanel.this.repaint();
                }
            }
        });
    }

    public void setResults(final AreaData data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                short[][] results = data.fetchData();
                DisplayPanel.this.data = data;
                DisplayPanel.this.image = DisplayPanel.this.createImage(results.length, results[0].length);
                Graphics g = DisplayPanel.this.image.getGraphics();
                for (int x = 0; x < results.length; ++x) {
                    for (int y = 0; y < results[x].length; ++y) {
                        Color c = results[x][y] == -1 ? Color.black : DisplayPanel.this.colors[results[x][y] % DisplayPanel.this.colors.length];
                        g.setColor(c);
                        g.drawLine(x, y, x, y);
                    }
                }
                DisplayPanel.this.point = null;
                DisplayPanel.this.range = null;
                DisplayPanel.this.progressdata = null;
                if (DisplayPanel.this.progressupdate != null) {
                    DisplayPanel.this.progressupdate.stop();
                    DisplayPanel.this.progressupdate = null;
                }
                DisplayPanel.this.calculating = false;
                DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                DisplayPanel.this.getParent().invalidate();
                DisplayPanel.this.getParent().doLayout();
                DisplayPanel.this.getParent().repaint();
            }
        });
    }

    public void addProgress(final ProgressData progress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Integer percent;
                if (DisplayPanel.this.progressdata == null) {
                    DisplayPanel.this.progressdata = new HashMap();
                }
                if ((percent = (Integer)DisplayPanel.this.progressdata.remove(progress)) == null || progress.isFinished()) {
                    percent = new Integer(progress.isFinished() ? 100 : 0);
                }
                DisplayPanel.this.progressdata.put(progress, percent);
                DisplayPanel.this.repaint();
                if (DisplayPanel.this.progressupdate == null) {
                    DisplayPanel.this.progressupdate = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DisplayPanel.this.calculating) {
                                DisplayPanel.this.agent.scheduleStep(new IComponentStep(){

                                    public Object execute(IInternalAccess ia) {
                                        ia.getServiceContainer().getRequiredService("cmsservice").addResultListener((IResultListener)new SwingDefaultResultListener(DisplayPanel.this){

                                            public void customResultAvailable(Object result) {
                                                IComponentManagementService cms = (IComponentManagementService)result;
                                                if (DisplayPanel.this.progressdata != null) {
                                                    Object[] pds = DisplayPanel.this.progressdata.keySet().toArray();
                                                    for (int i = 0; i < pds.length; ++i) {
                                                        final ProgressData progress = (ProgressData)pds[i];
                                                        if (progress.isFinished()) continue;
                                                        cms.getExternalAccess(progress.getProviderId()).addResultListener((IResultListener)new SwingDefaultResultListener(DisplayPanel.this){

                                                            public void customResultAvailable(Object result) {
                                                                IExternalAccess ea = (IExternalAccess)result;
                                                                SServiceProvider.getService((IServiceProvider)ea.getServiceProvider(), IProgressService.class).addResultListener((IResultListener)new SwingDefaultResultListener(DisplayPanel.this){

                                                                    public void customResultAvailable(Object result) {
                                                                        IProgressService ps = (IProgressService)result;
                                                                        if (ps != null) {
                                                                            ps.getProgress(progress.getTaskId()).addResultListener((IResultListener)new SwingDefaultResultListener(DisplayPanel.this){

                                                                                public void customResultAvailable(Object result) {
                                                                                    if (DisplayPanel.this.progressdata != null && DisplayPanel.this.progressdata.containsKey(progress)) {
                                                                                        Integer current = (Integer)result;
                                                                                        Integer percent = (Integer)DisplayPanel.this.progressdata.get(progress);
                                                                                        if (current > percent) {
                                                                                            DisplayPanel.this.progressdata.put(progress, current);
                                                                                            DisplayPanel.this.repaint();
                                                                                        }
                                                                                    }
                                                                                }

                                                                                public void customExceptionOccurred(Exception exception) {
                                                                                    if (DisplayPanel.this.progressdata != null) {
                                                                                        DisplayPanel.this.progressdata.remove(progress);
                                                                                    } else if (DisplayPanel.this.progressupdate != null) {
                                                                                        DisplayPanel.this.progressupdate.stop();
                                                                                        DisplayPanel.this.progressupdate = null;
                                                                                    }
                                                                                }
                                                                            });
                                                                        }
                                                                    }

                                                                    public void customExceptionOccurred(Exception exception) {
                                                                        if (DisplayPanel.this.progressdata != null) {
                                                                            DisplayPanel.this.progressdata.remove(progress);
                                                                        } else if (DisplayPanel.this.progressupdate != null) {
                                                                            DisplayPanel.this.progressupdate.stop();
                                                                            DisplayPanel.this.progressupdate = null;
                                                                        }
                                                                    }
                                                                });
                                                            }

                                                            public void customExceptionOccurred(Exception exception) {
                                                                if (DisplayPanel.this.progressdata != null) {
                                                                    DisplayPanel.this.progressdata.remove(progress);
                                                                } else if (DisplayPanel.this.progressupdate != null) {
                                                                    DisplayPanel.this.progressupdate.stop();
                                                                    DisplayPanel.this.progressupdate = null;
                                                                }
                                                            }
                                                        });
                                                    }
                                                }
                                            }

                                            public void customExceptionOccurred(Exception exception) {
                                                exception.printStackTrace();
                                            }
                                        });
                                        return null;
                                    }
                                });
                            } else if (DisplayPanel.this.progressupdate != null) {
                                DisplayPanel.this.progressupdate.stop();
                                DisplayPanel.this.progressupdate = null;
                            }
                        }
                    });
                    DisplayPanel.this.progressupdate.start();
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle bounds;
        super.paintComponent(g);
        if (this.image != null) {
            bounds = this.getInnerBounds(true);
            int ix = 0;
            int iy = 0;
            int iwidth = this.image.getWidth(this);
            int iheight = this.image.getHeight(this);
            Rectangle drawarea = this.scaleToFit(bounds, iwidth, iheight);
            if (this.calculating && this.range != null) {
                ix = (this.range.x - drawarea.x - bounds.x) * iwidth / drawarea.width;
                iy = (this.range.y - drawarea.y - bounds.y) * iheight / drawarea.height;
                iwidth = this.range.width * iwidth / drawarea.width;
                iheight = this.range.height * iheight / drawarea.height;
                drawarea = this.scaleToFit(bounds, iwidth, iheight);
                g.drawImage(this.image, bounds.x + drawarea.x, bounds.y + drawarea.y, bounds.x + drawarea.x + drawarea.width, bounds.y + drawarea.y + drawarea.height, ix, iy, ix + iwidth, iy + iheight, this);
            } else if (this.startdrag != null && this.enddrag != null) {
                g.drawImage(this.image, bounds.x + drawarea.x, bounds.y + drawarea.y, bounds.x + drawarea.x + drawarea.width, bounds.y + drawarea.y + drawarea.height, ix, iy, ix + iwidth, iy + iheight, this);
                g.setColor(new Color(32, 32, 32, 160));
                g.fillRect(bounds.x + drawarea.x, bounds.y + drawarea.y, drawarea.width, drawarea.height);
                Shape clip = g.getClip();
                g.setClip(bounds.x + drawarea.x, bounds.y + drawarea.y, drawarea.width, drawarea.height);
                int xoff = this.enddrag.x - this.startdrag.x;
                int yoff = this.enddrag.y - this.startdrag.y;
                g.drawImage(this.image, bounds.x + drawarea.x + xoff, bounds.y + drawarea.y + yoff, bounds.x + drawarea.x + xoff + drawarea.width, bounds.y + drawarea.y + yoff + drawarea.height, ix, iy, ix + iwidth, iy + iheight, this);
                g.setClip(clip);
            } else {
                g.drawImage(this.image, bounds.x + drawarea.x, bounds.y + drawarea.y, bounds.x + drawarea.x + drawarea.width, bounds.y + drawarea.y + drawarea.height, ix, iy, ix + iwidth, iy + iheight, this);
            }
            if (this.progressdata != null) {
                JProgressBar bar = new JProgressBar(0, 100);
                bar.setStringPainted(true);
                Dimension barsize = bar.getPreferredSize();
                for (ProgressData progress : this.progressdata.keySet()) {
                    Graphics g2;
                    int y;
                    int x;
                    double xf = drawarea.getWidth() / (double)progress.getImageWidth();
                    double yf = drawarea.getHeight() / (double)progress.getImageHeight();
                    int corx = (int)((double)progress.getArea().x * xf);
                    int cory = (int)((double)progress.getArea().y * yf);
                    int corw = (int)((double)progress.getArea().width * xf);
                    int corh = (int)((double)progress.getArea().height * yf);
                    if (!progress.isFinished()) {
                        g.setColor(new Color(32, 32, 32, 160));
                        g.fillRect(bounds.x + drawarea.x + corx + 1, bounds.y + drawarea.y + cory + 1, corw - 1, corh - 1);
                    }
                    g.setColor(Color.white);
                    g.drawRect(bounds.x + drawarea.x + corx, bounds.y + drawarea.y + cory, corw, corh);
                    if (progress.getProviderId() == null) continue;
                    String name = progress.getProviderId().toString();
                    String provider = "";
                    int index = name.indexOf(64);
                    if (index != -1) {
                        provider = name.substring(index + 1);
                        name = name.substring(0, index);
                    }
                    FontMetrics fm = g.getFontMetrics();
                    Rectangle2D sb1 = fm.getStringBounds(name, g);
                    Rectangle2D sb2 = fm.getStringBounds(provider, g);
                    int width = (int)Math.max(sb1.getWidth(), sb2.getWidth());
                    int height = fm.getHeight() * 2 + barsize.height + 2;
                    if (width < corw - 4 && height < corh - 4) {
                        x = bounds.x + drawarea.x + corx + (corw - width) / 2;
                        y = bounds.y + drawarea.y + cory + (corh - height) / 2 + fm.getLeading() / 2;
                        g.drawString(name, x, y + fm.getAscent());
                        g.drawString(provider, x, y + fm.getAscent() + fm.getHeight());
                        if (progress.isFinished()) continue;
                        bar.setStringPainted(true);
                        bar.setValue(((Number)this.progressdata.get(progress)).intValue());
                        width = Math.min(corw - 10, barsize.width);
                        x = bounds.x + drawarea.x + corx + (corw - width) / 2;
                        y = y + fm.getHeight() * 2 + 2;
                        bar.setBounds(0, 0, width, barsize.height);
                        g2 = g.create();
                        g2.translate(x, y);
                        bar.paint(g2);
                        continue;
                    }
                    if (progress.isFinished() || corw <= 8 || corh <= 8) continue;
                    bar.setStringPainted(false);
                    x = bounds.x + drawarea.x + corx + 2;
                    y = bounds.y + drawarea.y + cory + Math.max((corh - barsize.height) / 2, 2);
                    bar.setValue(((Number)this.progressdata.get(progress)).intValue());
                    bar.setBounds(0, 0, corw - 4, Math.min(barsize.height, corh - 4));
                    g2 = g.create();
                    g2.translate(x, y);
                    bar.paint(g2);
                }
            }
        }
        if (!this.calculating && this.range != null) {
            bounds = this.getInnerBounds(false);
            double rratio = (double)this.range.width / (double)this.range.height;
            double bratio = (double)bounds.width / (double)bounds.height;
            if (rratio < bratio) {
                int drawwidth = this.range.height * bounds.width / bounds.height;
                int offset = (this.range.width - drawwidth) / 2;
                g.setColor(new Color(128, 128, 128, 64));
                g.fillRect(this.range.x + offset, this.range.y, -offset, this.range.height + 1);
                g.fillRect(this.range.x + this.range.width, this.range.y, -offset, this.range.height + 1);
            } else if (rratio > bratio) {
                int drawheight = this.range.width * bounds.height / bounds.width;
                int offset = (this.range.height - drawheight) / 2;
                g.setColor(new Color(128, 128, 128, 64));
                g.fillRect(this.range.x, this.range.y + offset, this.range.width + 1, -offset);
                g.fillRect(this.range.x, this.range.y + this.range.height, this.range.width + 1, -offset);
            }
            g.setColor(Color.white);
            g.drawRect(this.range.x, this.range.y, this.range.width, this.range.height);
        }
    }

    protected Rectangle scaleToFit(Rectangle bounds, int iwidth, int iheight) {
        double iratio = (double)iwidth / (double)iheight;
        double bratio = (double)bounds.width / (double)bounds.height;
        Rectangle drawarea = new Rectangle(0, 0, bounds.width, bounds.height);
        if (iratio < bratio) {
            double hratio = (double)bounds.height / (double)iheight;
            drawarea.width = (int)((double)iwidth * hratio);
            drawarea.x = (bounds.width - drawarea.width) / 2;
        } else if (iratio > bratio) {
            double wratio = (double)bounds.width / (double)iwidth;
            drawarea.height = (int)((double)iheight * wratio);
            drawarea.y = (bounds.height - drawarea.height) / 2;
        }
        return drawarea;
    }

    protected Rectangle getInnerBounds(boolean scrollarea) {
        Insets insets;
        Rectangle bounds = this.getBounds();
        if (!scrollarea && this.getParent() instanceof JViewport) {
            Rectangle pbounds = this.getParent().getParent().getBounds();
            if (bounds.width > pbounds.width || bounds.height > pbounds.height) {
                bounds = pbounds;
            }
        }
        if ((insets = this.getInsets()) != null) {
            bounds.x = insets.left;
            bounds.y = insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        } else {
            bounds.x = 0;
            bounds.y = 0;
        }
        return bounds;
    }

    @Override
    public Dimension getMinimumSize() {
        Insets ins = this.getInsets();
        Dimension ret = new Dimension(ins != null ? ins.left + ins.right : 0, ins != null ? ins.top + ins.bottom : 0);
        if (this.image != null) {
            ret.width += this.image.getWidth(this);
            ret.height += this.image.getHeight(this);
        }
        return ret;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setColorScheme(Color[] scheme, boolean cycle) {
        if (scheme == null || scheme.length == 0) {
            this.colors = new Color[]{Color.white};
        } else if (scheme.length == 1) {
            this.colors = scheme;
        } else if (cycle) {
            this.colors = new Color[scheme.length * 16];
            for (int i = 0; i < this.colors.length; ++i) {
                int index = i / 16;
                Color start = scheme[index];
                Color end = index + 1 < scheme.length ? scheme[index + 1] : scheme[0];
                this.colors[i] = new Color((int)((double)start.getRed() + (double)(i % 16) / 16.0 * (double)(end.getRed() - start.getRed())), (int)((double)start.getGreen() + (double)(i % 16) / 16.0 * (double)(end.getGreen() - start.getGreen())), (int)((double)start.getBlue() + (double)(i % 16) / 16.0 * (double)(end.getBlue() - start.getBlue())));
            }
        } else {
            short max = this.data != null ? this.data.getMax() : GenerateService.ALGORITHMS[0].getDefaultSettings().getMax();
            this.colors = new Color[max];
            for (int i = 0; i < this.colors.length; ++i) {
                int index = i * (scheme.length - 1) / max;
                double diff = (double)i * (double)(scheme.length - 1) / (double)max - (double)index;
                Color start = scheme[index];
                Color end = scheme[index + 1];
                this.colors[i] = new Color((int)((double)start.getRed() + diff * (double)(end.getRed() - start.getRed())), (int)((double)start.getGreen() + diff * (double)(end.getGreen() - start.getGreen())), (int)((double)start.getBlue() + diff * (double)(end.getBlue() - start.getBlue())));
            }
        }
        if (this.data != null) {
            this.setResults(this.data);
        }
    }

    protected void dragImage() {
        Rectangle bounds = this.getInnerBounds(true);
        Rectangle drawarea = this.scaleToFit(bounds, this.image.getWidth(this), this.image.getHeight(this));
        int xdiff = this.startdrag.x - this.enddrag.x;
        int ydiff = this.startdrag.y - this.enddrag.y;
        double xp = (double)xdiff / (double)drawarea.width;
        double yp = (double)ydiff / (double)drawarea.height;
        double xm = (this.data.getXEnd() - this.data.getXStart()) * xp;
        double ym = (this.data.getYEnd() - this.data.getYStart()) * yp;
        double xs = this.data.getXStart() + xm;
        double xe = this.data.getXEnd() + xm;
        double ys = this.data.getYStart() + ym;
        double ye = this.data.getYEnd() + ym;
        this.startdrag = null;
        this.enddrag = null;
        this.range = new Rectangle(bounds.x + drawarea.x + xdiff, bounds.y + drawarea.y + ydiff, drawarea.width, drawarea.height);
        this.calcArea(xs, xe, ys, ye, this.data.getSizeX(), this.data.getSizeY());
    }

    protected void zoomImage(int x, int y, double factor) {
        Rectangle bounds = this.getInnerBounds(true);
        int iwidth = this.image.getWidth(this);
        int iheight = this.image.getHeight(this);
        Rectangle drawarea = this.scaleToFit(bounds, iwidth, iheight);
        int mx = Math.min(bounds.x + drawarea.x + drawarea.width, Math.max(bounds.x + drawarea.x, x));
        int my = Math.min(bounds.y + drawarea.y + drawarea.height, Math.max(bounds.y + drawarea.y, y));
        double xrel = ((double)mx - (double)(bounds.x + drawarea.x)) / (double)drawarea.width;
        double yrel = ((double)my - (double)(bounds.y + drawarea.y)) / (double)drawarea.height;
        double wold = this.data.getXEnd() - this.data.getXStart();
        double hold = this.data.getYEnd() - this.data.getYStart();
        double wnew = wold * factor;
        double hnew = hold * factor;
        double wd = wold - wnew;
        double hd = hold - hnew;
        double xs = this.data.getXStart() + wd * xrel;
        double xe = xs + wnew;
        double ys = this.data.getYStart() + hd * yrel;
        double ye = ys + hnew;
        double xdiff = (double)drawarea.width - (double)drawarea.width * factor;
        double ydiff = (double)drawarea.height - (double)drawarea.height * factor;
        this.range = new Rectangle(bounds.x + drawarea.x + (int)Math.round(xdiff * xrel), bounds.y + drawarea.y + (int)Math.round(ydiff * yrel), (int)Math.round((double)drawarea.width * factor), (int)Math.round((double)drawarea.height * factor));
        this.calcArea(xs, xe, ys, ye, this.data.getSizeX(), this.data.getSizeY());
    }

    protected void calcDefaultImage() {
        double bratio;
        AreaData settings = this.data != null ? this.data.getAlgorithm().getDefaultSettings() : GenerateService.ALGORITHMS[0].getDefaultSettings();
        Rectangle bounds = this.getInnerBounds(false);
        double rratio = (double)settings.getSizeX() / (double)settings.getSizeY();
        if (rratio < (bratio = (double)bounds.width / (double)bounds.height)) {
            int width;
            bounds.width = width = (int)((double)bounds.height * rratio);
        } else if (rratio > bratio) {
            int height;
            bounds.height = height = (int)((double)bounds.width / rratio);
        } else if (bounds.width == 0 || bounds.height == 0) {
            bounds.width = settings.getSizeX();
            bounds.height = settings.getSizeY();
        }
        this.image = this.createImage(bounds.width, bounds.height);
        this.calcArea(settings.getXStart(), settings.getXEnd(), settings.getYStart(), settings.getYEnd(), bounds.width, bounds.height);
    }

    protected void zoomIntoRange() {
        Rectangle bounds = this.getInnerBounds(true);
        Rectangle drawarea = this.scaleToFit(bounds, this.image.getWidth(this), this.image.getHeight(this));
        double x = (double)(this.range.x - bounds.x - drawarea.x) / (double)drawarea.width;
        double y = (double)(this.range.y - bounds.y - drawarea.y) / (double)drawarea.height;
        double x2 = x + (double)this.range.width / (double)drawarea.width;
        double y2 = y + (double)this.range.height / (double)drawarea.height;
        double ox = this.data.getXStart();
        double oy = this.data.getYStart();
        double owidth = this.data.getXEnd() - this.data.getXStart();
        double oheight = this.data.getYEnd() - this.data.getYStart();
        bounds = this.getInnerBounds(false);
        double rratio = (double)this.range.width / (double)this.range.height;
        double bratio = (double)bounds.width / (double)bounds.height;
        if (rratio < bratio) {
            bounds.width = (int)((double)bounds.height * rratio);
        } else if (rratio > bratio) {
            bounds.height = (int)((double)bounds.width / rratio);
        }
        Rectangle area = bounds;
        this.calcArea(ox + owidth * x, ox + owidth * x2, oy + oheight * y, oy + oheight * y2, area.width, area.height);
    }

    protected void calcArea(double x1, double x2, double y1, double y2, int sizex, int sizey) {
        AreaData settings = this.data == null ? GenerateService.ALGORITHMS[0].getDefaultSettings() : this.data;
        final AreaData ad = new AreaData(x1, x2, y1, y2, sizex, sizey, settings.getMax(), settings.getParallel(), settings.getTaskSize(), settings.getAlgorithm());
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.calculating = true;
        this.repaint();
        this.agent.scheduleStep(new IComponentStep(){

            public Object execute(IInternalAccess ia) {
                ia.getServiceContainer().getRequiredService("generateservice").addResultListener((IResultListener)new SwingDefaultResultListener(){

                    public void customResultAvailable(Object result) {
                        IGenerateService gs = (IGenerateService)result;
                        IFuture fut = gs.generateArea(ad);
                        fut.addResultListener((IResultListener)new SwingDefaultResultListener(DisplayPanel.this){

                            public void customResultAvailable(Object result) {
                                DisplayPanel.this.setResults((AreaData)result);
                            }

                            public void customExceptionOccurred(Exception exception) {
                                DisplayPanel.this.calculating = false;
                                DisplayPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                                super.customExceptionOccurred(exception);
                            }
                        });
                    }
                });
                return null;
            }
        });
    }
}

