/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.ping;

import jadex.base.fipa.SFipa;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.MessageType;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.IArgument;
import jadex.commons.SUtil;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PingingAgent
extends MicroAgent {
    protected IComponentIdentifier receiver;
    protected int dif;
    protected Set sent;

    public void executeBody() {
        this.receiver = (IComponentIdentifier)this.getArgument("receiver");
        final int missed_max = ((Number)this.getArgument("missed_max")).intValue();
        final long timeout = ((Number)this.getArgument("timeout")).longValue();
        final Object content = this.getArgument("content");
        this.sent = new HashSet();
        final IComponentStep step = new IComponentStep(){

            public Object execute(IInternalAccess ia) {
                if (PingingAgent.this.dif > missed_max) {
                    PingingAgent.this.getLogger().warning("Ping target does not respond: " + PingingAgent.this.receiver);
                    PingingAgent.this.killAgent();
                } else {
                    String convid = SUtil.createUniqueId((String)PingingAgent.this.getAgentName());
                    HashMap<String, Object> msg = new HashMap<String, Object>();
                    msg.put("content", content);
                    msg.put("performative", "query-if");
                    msg.put("conversation_id", convid);
                    msg.put("receivers", new IComponentIdentifier[]{PingingAgent.this.receiver});
                    ++PingingAgent.this.dif;
                    PingingAgent.this.sent.add(convid);
                    PingingAgent.this.sendMessage(msg, SFipa.FIPA_MESSAGE_TYPE);
                    PingingAgent.this.waitFor(timeout, this);
                }
                return null;
            }
        };
        if (this.receiver == null) {
            this.createComponentIdentifier("Ping").addResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object result) {
                    PingingAgent.this.receiver = (IComponentIdentifier)result;
                    PingingAgent.this.scheduleStep(step);
                }
            });
        } else {
            this.scheduleStep(step);
        }
    }

    public void messageArrived(Map msg, MessageType mt) {
        String convid;
        if (mt.equals((Object)SFipa.FIPA_MESSAGE_TYPE) && this.sent.remove(convid = (String)msg.get("conversation_id"))) {
            this.dif = 0;
            this.sent.clear();
        }
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("A simple agent that sends pings to another agent and waits for replies.", null, new IArgument[]{new Argument("receiver", "The component receiver of the ping target.", "IComponentIdentifier"), new Argument("missed_max", "Maximum number of allowed missed replies", "int", (Object)new Integer(3)), new Argument("timeout", "Timeout for reply", "long", (Object)new Long(1000L)), new Argument("content", "Ping message content", "String", (Object)"ping")}, null);
    }
}

