/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.watchdog;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.watchdog.IWatchdogService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

@ProvidedServices(value={@ProvidedService(type=IWatchdogService.class, implementation=@Implementation(expression="$component"))})
@RequiredServices(value={@RequiredService(name="watchdogs", type=IWatchdogService.class, multiple=true, binding=@Binding(scope="global", dynamic=true))})
@Arguments(value={@Argument(clazz=long.class, name="delay", description="Delay between pings.", defaultvalue="3000")})
public class WatchdogAgent
extends MicroAgent
implements IWatchdogService {
    protected Map watchdogs;

    public IFuture agentCreated() {
        this.watchdogs = new LinkedHashMap();
        final long delay = ((Number)this.getArgument("delay")).longValue();
        this.scheduleStep(new IComponentStep(){

            public Object execute(IInternalAccess ia) {
                final 1 step = this;
                Object[] keys = WatchdogAgent.this.watchdogs.keySet().toArray();
                CounterResultListener crl = new CounterResultListener(keys.length, new IResultListener(){

                    public void resultAvailable(Object result) {
                        WatchdogAgent.this.getRequiredServices("watchdogs").addResultListener(new IResultListener(){

                            public void resultAvailable(Object result) {
                                if (result instanceof Collection) {
                                    for (IWatchdogService watchdog : (Collection)result) {
                                        if (watchdog.getInfo().equals(WatchdogAgent.this.getInfo())) continue;
                                        WatchdogAgent.this.watchdogs.put(watchdog.getInfo(), watchdog);
                                    }
                                }
                                WatchdogAgent.this.waitFor(delay, step);
                            }

                            public void exceptionOccurred(Exception exception) {
                                throw exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
                            }
                        });
                    }

                    public void exceptionOccurred(Exception exception) {
                        throw exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
                    }
                });
                for (int i = 0; i < keys.length; ++i) {
                    Object key = keys[i];
                    IWatchdogService watchdog = (IWatchdogService)WatchdogAgent.this.watchdogs.get(key);
                    watchdog.ping().addResultListener(new IResultListener((IResultListener)crl, key){
                        final /* synthetic */ IResultListener val$crl;
                        final /* synthetic */ Object val$key;
                        {
                            this.val$crl = iResultListener;
                            this.val$key = object;
                        }

                        public void resultAvailable(Object result) {
                            this.val$crl.resultAvailable(null);
                        }

                        public void exceptionOccurred(Exception exception) {
                            System.out.println("Watchdog triggered: " + this.val$key);
                            WatchdogAgent.this.watchdogs.remove(this.val$key);
                            this.val$crl.resultAvailable(null);
                        }
                    });
                }
                return null;
            }
        });
        return IFuture.DONE;
    }

    @Override
    public String getInfo() {
        return this.getComponentIdentifier().getName();
    }

    @Override
    public IFuture ping() {
        return IFuture.DONE;
    }
}

