/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.CreationInfo;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.MicroAgent;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.BrokenInitAgent;

@Description(value="Testing broken init.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class)})
public class BrokenInitTestAgent
extends MicroAgent {
    public void executeBody() {
        final TestReport tr1 = new TestReport("#1", "Direct subcomponent.");
        this.testBrokenComponent(BrokenInitAgent.class.getName() + ".class").addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                tr1.setSucceeded(true);
                this.next();
            }

            public void exceptionOccurred(Exception exception) {
                tr1.setFailed(exception.getMessage());
                this.next();
            }

            protected void next() {
                final TestReport tr2 = new TestReport("#2", "Nested subcomponent.");
                BrokenInitTestAgent.this.testBrokenComponent("jadex/micro/testcases/BrokenInit.component.xml").addResultListener(BrokenInitTestAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        tr2.setSucceeded(true);
                        this.next();
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr2.setFailed(exception.getMessage());
                        this.next();
                    }

                    protected void next() {
                        BrokenInitTestAgent.this.setResultValue("testresults", new Testcase(2, new TestReport[]{tr1, tr2}));
                        BrokenInitTestAgent.this.killAgent();
                    }
                }));
            }
        }));
    }

    protected IFuture testBrokenComponent(final String model) {
        final Future fut1 = new Future();
        this.getRequiredService("cms").addResultListener((IResultListener)new DelegationResultListener(fut1){

            public void customResultAvailable(Object result) {
                final IComponentManagementService cms = (IComponentManagementService)result;
                cms.createComponent(null, model, new CreationInfo(BrokenInitTestAgent.this.getComponentIdentifier()), null).addResultListener(BrokenInitTestAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        fut1.setException((Exception)new RuntimeException("Creation unexpectedly succeded."));
                        cms.destroyComponent((IComponentIdentifier)result);
                    }

                    public void exceptionOccurred(Exception exception) {
                        if (exception.getMessage().equals("Exception in init.")) {
                            fut1.setResult(null);
                        } else {
                            fut1.setException(exception);
                        }
                    }
                }));
            }
        });
        return fut1;
    }
}

